/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch;

import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SoapRecordToMapTransformer {
    private static final String SUB_QUERY_FIELDS_PARENT = "records";

    public Map<String, ?> transformToMap(SObject sObject, SObjectDescriptor sObjectDescriptor) {
        HashMap<String, String> result = new HashMap<String, String>(this.transformRowToMap((XmlObject)sObject, sObjectDescriptor));
        for (SObjectDescriptor childSObjectDescriptor : sObjectDescriptor.getChildSObjects()) {
            XmlObject child = sObject.getChild(childSObjectDescriptor.getName());
            if (child == null) {
                throw new IllegalStateException(String.format("SObject sub-query field with name '%s' not found in parent '%s'", childSObjectDescriptor.getName(), sObject.getName().getLocalPart()));
            }
            Iterable subValues = () -> child.getChildren(SUB_QUERY_FIELDS_PARENT);
            List subQueryValues = StreamSupport.stream(subValues.spliterator(), false).map(subValue -> this.transformRowToMap((XmlObject)subValue, childSObjectDescriptor)).collect(Collectors.toList());
            result.put(childSObjectDescriptor.getName(), (String)((Object)subQueryValues));
        }
        return result;
    }

    public Map<String, String> transformRowToMap(XmlObject sObject, SObjectDescriptor sObjectDescriptor) {
        HashMap<String, String> result = new HashMap<String, String>(sObjectDescriptor.getFields().size());
        for (SObjectDescriptor.FieldDescriptor fieldDescriptor : sObjectDescriptor.getFields()) {
            Object fieldValue = fieldDescriptor.getAlias() != null ? this.extractValue(sObject, fieldDescriptor.getAlias(), Collections.emptyList()) : this.extractValue(sObject, fieldDescriptor.getName(), fieldDescriptor.getParents());
            result.put(fieldDescriptor.getQueryName(), fieldValue == null ? null : String.valueOf(fieldValue));
        }
        return result;
    }

    private Object extractValue(XmlObject xmlObject, String name, List<String> children) {
        if (children.isEmpty()) {
            return xmlObject.getField(name);
        }
        String childName = children.get(0);
        XmlObject child = xmlObject.getChild(childName);
        if (child == null) {
            throw new IllegalStateException(String.format("SObject reference field with name '%s' not found in parent '%s'", childName, xmlObject.getName().getLocalPart()));
        }
        return this.extractValue(child, name, children.subList(1, children.size()));
    }
}

