/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.batch.util;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import io.cdap.plugin.salesforce.BulkAPIBatchException;
import io.cdap.plugin.salesforce.InvalidConfigException;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SalesforceBulkUtil;
import io.cdap.plugin.salesforce.SalesforceQueryUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSplit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SalesforceSplitUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceSplitUtil.class);

    public static List<SalesforceSplit> getQuerySplits(String query, BulkConnection bulkConnection, boolean enablePKChunk, String operation) {
        return Stream.of(SalesforceSplitUtil.getBatches(query, bulkConnection, enablePKChunk, operation)).map(batch -> new SalesforceSplit(batch.getJobId(), batch.getId(), query)).collect(Collectors.toList());
    }

    private static BatchInfo[] getBatches(String query, BulkConnection bulkConnection, boolean enablePKChunk, String operation) {
        try {
            if (!SalesforceQueryUtil.isQueryUnderLengthLimit(query)) {
                LOG.debug("Wide object query detected. Query length '{}'", (Object)query.length());
                query = SalesforceQueryUtil.createSObjectIdQuery(query);
            }
            BatchInfo[] batches = SalesforceSplitUtil.runBulkQuery(bulkConnection, query, enablePKChunk, operation);
            LOG.debug("Number of batches received from Salesforce: '{}'", (Object)batches.length);
            return batches;
        }
        catch (AsyncApiException | IOException e) {
            throw new RuntimeException("There was issue communicating with Salesforce", e);
        }
    }

    private static BatchInfo[] runBulkQuery(BulkConnection bulkConnection, String query, boolean enablePKChunk, String operation) throws AsyncApiException, IOException {
        BatchInfo batchInfo;
        SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromQuery(query);
        JobInfo job = SalesforceBulkUtil.createJob(bulkConnection, sObjectDescriptor.getName(), SalesforceSplitUtil.getOperationEnum(operation), null);
        try (ByteArrayInputStream bout = new ByteArrayInputStream(query.getBytes());){
            batchInfo = bulkConnection.createBatchFromStream(job, (InputStream)bout);
        }
        if (enablePKChunk) {
            LOG.debug("PKChunking is enabled");
            return SalesforceSplitUtil.waitForBatchChunks(bulkConnection, job.getId(), batchInfo.getId());
        }
        LOG.debug("PKChunking is not enabled");
        BatchInfo[] batchInfos = bulkConnection.getBatchInfoList(job.getId()).getBatchInfo();
        LOG.info("Job id {}, status: {}", (Object)job.getId(), (Object)bulkConnection.getJobStatus(job.getId()).getState());
        if (batchInfos.length > 0) {
            LOG.info("Batch size {}, state {}", (Object)batchInfos.length, (Object)batchInfos[0].getState());
        }
        return batchInfos;
    }

    public static BulkConnection getBulkConnection(AuthenticatorCredentials authenticatorCredentials) {
        try {
            return new BulkConnection(Authenticator.createConnectorConfig(authenticatorCredentials));
        }
        catch (AsyncApiException e) {
            throw new RuntimeException("There was issue communicating with Salesforce", e);
        }
    }

    private static BatchInfo[] waitForBatchChunks(BulkConnection bulkConnection, String jobId, String initialBatchId) throws AsyncApiException {
        BatchInfo initialBatchInfo = null;
        int i = 0;
        while ((long)i < 1200L) {
            block9: {
                if (bulkConnection.getJobStatus(jobId).getState() == JobStateEnum.Aborted) {
                    LOG.info(String.format("Job with Id: '%s' is aborted", jobId));
                    return new BatchInfo[0];
                }
                try {
                    initialBatchInfo = bulkConnection.getBatchInfo(jobId, initialBatchId);
                }
                catch (AsyncApiException e) {
                    if ((long)i == 1199L) {
                        throw e;
                    }
                    LOG.warn("Failed to get info for batch {}. Will retry after some time.", (Object)initialBatchId, (Object)e);
                    break block9;
                }
                if (initialBatchInfo.getState() == BatchStateEnum.NotProcessed) {
                    BatchInfo[] result = bulkConnection.getBatchInfoList(jobId).getBatchInfo();
                    return (BatchInfo[])Arrays.stream(result).filter(batchInfo -> batchInfo.getState() != BatchStateEnum.NotProcessed).toArray(BatchInfo[]::new);
                }
                if (initialBatchInfo.getState() == BatchStateEnum.Failed) {
                    throw new BulkAPIBatchException("Batch failed", initialBatchInfo);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Job is aborted", e);
                }
            }
            ++i;
        }
        throw new BulkAPIBatchException("Timeout waiting for batch results", initialBatchInfo);
    }

    public static void closeJobs(Set<String> jobIds, AuthenticatorCredentials authenticatorCredentials) {
        BulkConnection bulkConnection = SalesforceSplitUtil.getBulkConnection(authenticatorCredentials);
        Throwable runtimeException = null;
        for (String jobId : jobIds) {
            try {
                SalesforceBulkUtil.closeJob(bulkConnection, jobId);
            }
            catch (AsyncApiException e) {
                if (runtimeException == null) {
                    runtimeException = new RuntimeException(e);
                    continue;
                }
                runtimeException.addSuppressed(e);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    private static OperationEnum getOperationEnum(String operation) {
        try {
            return OperationEnum.valueOf((String)operation);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidConfigException("Unsupported value for operation: " + operation, "operation");
        }
    }
}

