/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.streaming;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.cdap.plugin.salesforce.authenticator.AuthenticatorCredentials;
import io.cdap.plugin.salesforce.plugin.source.streaming.SalesforcePushTopicListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceReceiver
extends Receiver<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceReceiver.class);
    private static final String RECEIVER_THREAD_NAME = "salesforce_streaming_api_listener";
    private static final long GET_MESSAGE_TIMEOUT_SECONDS = 2L;
    private final AuthenticatorCredentials credentials;
    private final String topic;
    private SalesforcePushTopicListener pushTopicListener;

    SalesforceReceiver(AuthenticatorCredentials credentials, String topic) {
        super(StorageLevel.MEMORY_AND_DISK_2());
        this.credentials = credentials;
        this.topic = topic;
    }

    public void onStart() {
        this.pushTopicListener = new SalesforcePushTopicListener(this.credentials, this.topic);
        this.pushTopicListener.start();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("salesforce_streaming_api_listener-%d").build();
        Executors.newSingleThreadExecutor(namedThreadFactory).submit(this::receive);
    }

    public void onStop() {
    }

    private void receive() {
        try {
            while (!this.isStopped()) {
                String message = this.pushTopicListener.getMessage(2L, TimeUnit.SECONDS);
                if (message == null) continue;
                this.store(message);
            }
        }
        catch (Exception e) {
            String errorMessage = "Exception while receiving messages from pushTopic";
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }
}

