/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.salesforce.plugin.source.streaming;

import com.google.common.base.Strings;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.validation.InvalidStageException;
import io.cdap.plugin.salesforce.InvalidConfigException;
import io.cdap.plugin.salesforce.SObjectDescriptor;
import io.cdap.plugin.salesforce.SObjectFilterDescriptor;
import io.cdap.plugin.salesforce.SalesforceQueryUtil;
import io.cdap.plugin.salesforce.authenticator.Authenticator;
import io.cdap.plugin.salesforce.plugin.BaseSalesforceConfig;
import io.cdap.plugin.salesforce.plugin.OAuthInfo;
import io.cdap.plugin.salesforce.soap.SObjectBuilder;
import io.cdap.plugin.salesforce.soap.SObjectUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceStreamingSourceConfig
extends BaseSalesforceConfig
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceStreamingSourceConfig.class);
    private static final long serialVersionUID = 4218063781902315444L;
    private static final Pattern isValidFieldNamePattern = Pattern.compile("[a-zA-Z0-9.-_]+");
    protected static final String ENABLED_KEYWORD = "Enabled";
    protected static final String PROPERTY_PUSH_TOPIC_NAME = "pushTopicName";
    protected static final String PROPERTY_PUSH_TOPIC_QUERY = "pushTopicQuery";
    protected static final String PROPERTY_SOBJECT_NAME = "sObjectName";
    @Description(value="Salesforce push topic name. Plugin will track updates from this topic. If topic does not exist, it will be automatically created. To manually create pushTopic use Salesforce workbench or Apex code or API.")
    @Name(value="pushTopicName")
    @Macro
    private String pushTopicName;
    @Description(value="Salesforce push topic query. The query is used by Salesforce to send updates to push topic. This field not required, if you are using an existing push topic.")
    @Nullable
    @Name(value="pushTopicQuery")
    @Macro
    private String pushTopicQuery;
    @Description(value="Push topic property, which specifies if a create operation should generate a record.")
    @Name(value="pushTopicNotifyCreate")
    private String pushTopicNotifyCreate;
    @Description(value="Push topic property, which specifies if a update operation should generate a record.")
    @Name(value="pushTopicNotifyUpdate")
    private String pushTopicNotifyUpdate;
    @Description(value="Push topic property, which specifies if an delete operation should generate a record.")
    @Name(value="pushTopicNotifyDelete")
    private String pushTopicNotifyDelete;
    @Description(value="Salesforce SObject name used to automatically generate query. Example: Opportunity.")
    @Nullable
    @Name(value="sObjectName")
    @Macro
    private String sObjectName;
    @Description(value="Push topic property, which specifies how the record is evaluated against the PushTopic query.\nThe NotifyForFields values are:\nAll - Notifications are generated for all record field changes, provided the evaluated records match the criteria specified in the WHERE clause.\nReferenced (default) - Changes to fields referenced in the SELECT and WHERE clauses are evaluated. Notifications are generated for the evaluated records only if they match the criteria specified in the WHERE clause.\nSelect - Changes to fields referenced in the SELECT clause are evaluated. Notifications are generated for the evaluated records only if they match the criteria specified in the WHERE clause.\nWhere - Changes to fields referenced in the WHERE clause are evaluated. Notifications are generated for the evaluated records only if they match the criteria specified in the WHERE clause.")
    @Name(value="pushTopicNotifyForFields")
    private String pushTopicNotifyForFields;

    public SalesforceStreamingSourceConfig(String referenceName, @Nullable String consumerKey, @Nullable String consumerSecret, @Nullable String username, @Nullable String password, @Nullable String loginUrl, String pushTopicName, String sObjectName, @Nullable String securityToken, @Nullable OAuthInfo oAuthInfo) {
        super(referenceName, consumerKey, consumerSecret, username, password, loginUrl, securityToken, oAuthInfo);
        this.pushTopicName = pushTopicName;
        this.sObjectName = sObjectName;
    }

    public String getPushTopicName() {
        return this.pushTopicName;
    }

    public String getPushTopicQuery() {
        return this.pushTopicQuery;
    }

    public Boolean isPushTopicNotifyCreate() {
        return this.pushTopicNotifyCreate.equals(ENABLED_KEYWORD);
    }

    public Boolean isPushTopicNotifyUpdate() {
        return this.pushTopicNotifyUpdate.equals(ENABLED_KEYWORD);
    }

    public Boolean isPushTopicNotifyDelete() {
        return this.pushTopicNotifyDelete.equals(ENABLED_KEYWORD);
    }

    public String getPushTopicNotifyForFields() {
        return this.pushTopicNotifyForFields;
    }

    @Nullable
    public String getQuery() {
        if (!Strings.isNullOrEmpty((String)this.pushTopicQuery)) {
            return this.pushTopicQuery;
        }
        if (!Strings.isNullOrEmpty((String)this.sObjectName)) {
            return this.getSObjectQuery();
        }
        return null;
    }

    public void ensurePushTopicExistAndWithCorrectFields() {
        if (this.containsMacro(PROPERTY_PUSH_TOPIC_NAME) || this.containsMacro(PROPERTY_PUSH_TOPIC_QUERY) || !this.canAttemptToEstablishConnection()) {
            return;
        }
        try {
            PartnerConnection partnerConnection = new PartnerConnection(Authenticator.createConnectorConfig(this.getAuthenticatorCredentials()));
            SObject pushTopic = SalesforceStreamingSourceConfig.fetchPushTopicByName(partnerConnection, this.pushTopicName);
            String query = this.getQuery();
            if (pushTopic == null) {
                LOG.info("Creating PushTopic {}", (Object)this.pushTopicName);
                if (Strings.isNullOrEmpty((String)query)) {
                    throw new InvalidConfigException("SOQL query or SObject name must be provided, unless existing pushTopic is used", PROPERTY_PUSH_TOPIC_QUERY);
                }
                pushTopic = new SObjectBuilder().setType("PushTopic").put("Name", this.pushTopicName).put("Query", query).put("NotifyForOperationCreate", this.isPushTopicNotifyCreate().toString()).put("NotifyForOperationUpdate", this.isPushTopicNotifyUpdate().toString()).put("NotifyForOperationDelete", this.isPushTopicNotifyDelete().toString()).put("NotifyForFields", this.getPushTopicNotifyForFields()).put("ApiVersion", "53.0").build();
                SObjectUtil.createSObjects(partnerConnection, new SObject[]{pushTopic});
            } else {
                if (!Strings.isNullOrEmpty((String)query)) {
                    SalesforceStreamingSourceConfig.assertFieldValue(pushTopic, "Query", query);
                } else {
                    this.pushTopicQuery = (String)pushTopic.getField("Query");
                }
                SalesforceStreamingSourceConfig.assertFieldValue(pushTopic, "NotifyForOperationCreate", this.isPushTopicNotifyCreate().toString());
                SalesforceStreamingSourceConfig.assertFieldValue(pushTopic, "NotifyForOperationUpdate", this.isPushTopicNotifyUpdate().toString());
                SalesforceStreamingSourceConfig.assertFieldValue(pushTopic, "NotifyForOperationDelete", this.isPushTopicNotifyDelete().toString());
                SalesforceStreamingSourceConfig.assertFieldValue(pushTopic, "NotifyForFields", this.getPushTopicNotifyForFields());
            }
        }
        catch (ConnectionException e) {
            throw new InvalidStageException("Cannot connect to Salesforce API with credentials specified.", (Throwable)e);
        }
    }

    public static SObject fetchPushTopicByName(PartnerConnection partnerConnection, String pushTopicName) throws ConnectionException {
        if (!SalesforceStreamingSourceConfig.isValidFieldName(pushTopicName)) {
            throw new IllegalArgumentException(String.format("Push topic name '%s' can only contain latin letters.", pushTopicName));
        }
        QueryResult queryResult = SalesforceStreamingSourceConfig.runQuery(partnerConnection, String.format("SELECT Id, Name, Query, NotifyForOperationCreate, NotifyForOperationUpdate, NotifyForOperationDelete, NotifyForFields FROM PushTopic WHERE Name = '%s'", pushTopicName));
        SObject[] records = queryResult.getRecords();
        switch (records.length) {
            case 0: {
                return null;
            }
            case 1: {
                return records[0];
            }
        }
        throw new IllegalStateException(String.format("Excepted one or zero pushTopics with name = '%s' found %d", pushTopicName, records.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryResult runQuery(PartnerConnection partnerConnection, String query) throws ConnectionException {
        ClassLoader classClassLoader;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        boolean usesDifferentClassLoaders = !threadClassLoader.equals(classClassLoader = SalesforceStreamingSourceConfig.class.getClassLoader());
        try {
            if (usesDifferentClassLoaders) {
                Thread.currentThread().setContextClassLoader(classClassLoader);
            }
            QueryResult queryResult = partnerConnection.query(query);
            return queryResult;
        }
        finally {
            if (usesDifferentClassLoaders) {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }
    }

    private static boolean isValidFieldName(String name) {
        Matcher m = isValidFieldNamePattern.matcher(name);
        return m.matches();
    }

    private static void assertFieldValue(SObject pushTopic, String fieldName, Object expectedResult) {
        Object actual = pushTopic.getField(fieldName);
        if (!expectedResult.equals(actual)) {
            throw new IllegalArgumentException(String.format("Push topic field %s='%s', but existing value on server is '%s'", fieldName, expectedResult, actual));
        }
    }

    @Nullable
    private String getSObjectQuery() {
        if (!this.canAttemptToEstablishConnection()) {
            return null;
        }
        try {
            Set<FieldType> typesToSkip = Collections.singleton(FieldType.textarea);
            SObjectDescriptor sObjectDescriptor = SObjectDescriptor.fromName(this.sObjectName, this.getAuthenticatorCredentials(), typesToSkip);
            String sObjectQuery = SalesforceQueryUtil.createSObjectQuery(sObjectDescriptor.getFieldsNames(), this.sObjectName, SObjectFilterDescriptor.noOp());
            LOG.debug("Generated SObject query: '{}'", (Object)sObjectQuery);
            return sObjectQuery;
        }
        catch (ConnectionException e) {
            throw new IllegalStateException(String.format("Cannot establish connection to Salesforce to describe SObject: '%s'", this.sObjectName), e);
        }
    }
}

