/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.restapi;

import io.cdap.plugin.servicenow.restapi.RestAPIRequest;
import io.cdap.plugin.servicenow.restapi.RestAPIResponse;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public abstract class RestAPIClient {
    public RestAPIResponse executeGet(RestAPIRequest request) {
        HttpGet httpGet = new HttpGet(request.getUrl());
        request.getHeaders().entrySet().forEach(e -> httpGet.addHeader((String)e.getKey(), (String)e.getValue()));
        RestAPIResponse apiResponse = null;
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();
             CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
            apiResponse = RestAPIResponse.parse((HttpResponse)httpResponse, request.getResponseHeaders());
        }
        catch (Exception e2) {
            apiResponse = RestAPIResponse.defaultErrorResponse(e2.getMessage());
        }
        return apiResponse;
    }

    protected RestAPIResponse executePost(RestAPIRequest request) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(request.getUrl());
        request.getHeaders().entrySet().forEach(e -> httpPost.addHeader((String)e.getKey(), (String)e.getValue()));
        httpPost.setEntity(request.getEntity());
        RestAPIResponse apiResponse = null;
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();
             CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            apiResponse = RestAPIResponse.parse((HttpResponse)httpResponse, request.getResponseHeaders());
        }
        catch (Exception e2) {
            apiResponse = RestAPIResponse.defaultErrorResponse(e2.getMessage());
        }
        return apiResponse;
    }

    protected String generateAccessToken(String restApiEndpoint, String clientId, String clientSecret, String user, String password) throws OAuthSystemException, OAuthProblemException {
        String token = "NO-VALUE";
        OAuthClient client = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)restApiEndpoint).setGrantType(GrantType.PASSWORD).setClientId(clientId).setClientSecret(clientSecret).setUsername(user).setPassword(password).buildBodyMessage();
        token = ((OAuthJSONAccessTokenResponse)client.accessToken(request, "POST", OAuthJSONAccessTokenResponse.class)).getAccessToken();
        return token;
    }
}

