/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.restapi;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;

public class RestAPIRequest {
    private String url;
    private Map<String, String> headers;
    private HttpEntity entity;
    private String[] responseHeaders;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public String[] getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(String[] responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public static abstract class Builder {
        protected String url;
        protected Map<String, String> headers = new HashMap<String, String>();
        protected Map<String, String> parameters = new HashMap<String, String>();
        protected HttpEntity entity;
        protected String[] responseHeaders;

        protected Builder(String url) {
            this.url = url;
        }

        public Builder setAuthHeader(String token) {
            this.headers.put("Authorization", String.format("Bearer %s", token));
            return this;
        }

        public Builder setAcceptHeader(String acceptHeaderValue) {
            this.headers.put("Accept", acceptHeaderValue);
            return this;
        }

        public Builder setContentTypeHeader(String contentTypeHeaderValue) {
            this.headers.put("Content-type", contentTypeHeaderValue);
            return this;
        }

        public Builder setEntity(HttpEntity entity) {
            this.entity = entity;
            return this;
        }

        public Builder setResponseHeaders(String ... responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public RestAPIRequest build() {
            RestAPIRequest request = new RestAPIRequest();
            request.setUrl(this.attachQueryParamsToUrl(this.url, this.parameters));
            request.setHeaders(this.headers);
            if (this.entity != null) {
                request.setEntity(this.entity);
            }
            request.setResponseHeaders(this.responseHeaders);
            return request;
        }

        private String attachQueryParamsToUrl(String url, Map<String, String> queryParams) {
            ArrayList parameters = new ArrayList();
            queryParams.forEach((k, v) -> parameters.add(String.format("%s=%s", k, v)));
            return String.format("%s%s", url, parameters.isEmpty() ? "" : "?" + Joiner.on((char)'&').join(parameters));
        }
    }
}

