/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.restapi;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class RestAPIResponse {
    private static List<Integer> successCodes = new ArrayList<Integer>(){
        {
            this.add(200);
        }
    };
    private static final String JSON_ERROR_RESPONSE_TEMPLATE = "{\n    \"error\": {\n        \"message\": \"%s\",\n        \"detail\": null\n    },\n    \"status\": \"failure\"\n}";
    private int httpStatus;
    private Map<String, String> headers;
    private String responseBody;
    private boolean isRetryable;

    public RestAPIResponse(int httpStatus, Map<String, String> headers, String responseBody) {
        this.httpStatus = httpStatus;
        this.headers = headers;
        this.responseBody = responseBody;
        this.checkRetryable();
    }

    public static RestAPIResponse defaultErrorResponse(String message) {
        return new RestAPIResponse(500, Collections.emptyMap(), String.format(JSON_ERROR_RESPONSE_TEMPLATE, message));
    }

    public static RestAPIResponse parse(HttpResponse httpResponse, String ... headerNames) {
        List<Object> headerNameList = headerNames == null ? Collections.emptyList() : Arrays.asList(headerNames);
        int httpStatus = httpResponse.getStatusLine().getStatusCode();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!headerNameList.isEmpty()) {
            headers.putAll(Arrays.stream(httpResponse.getAllHeaders()).filter(o -> headerNameList.contains(o.getName())).collect(Collectors.toMap(Header::getName, Header::getValue)));
        }
        String responseBody = "";
        try {
            responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            httpStatus = 500;
            return new RestAPIResponse(httpStatus, headers, String.format(JSON_ERROR_RESPONSE_TEMPLATE, e.getMessage()));
        }
        return new RestAPIResponse(httpStatus, headers, responseBody);
    }

    public static RestAPIResponse parse(HttpResponse httpResponse) {
        return RestAPIResponse.parse(httpResponse, new String[0]);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public boolean isSuccess() {
        boolean isSuccess = false;
        if (this.isRetryable) {
            isSuccess = false;
        } else if (successCodes.contains(this.getHttpStatus())) {
            isSuccess = true;
        }
        return isSuccess;
    }

    private void checkRetryable() {
        Gson gson = new Gson();
        JsonObject jo = (JsonObject)gson.fromJson(this.responseBody, JsonObject.class);
        if (jo.get("status") != null && jo.get("status").getAsString().equals("failure") && jo.getAsJsonObject("error").get("message").getAsString().contains("maximum execution time exceeded")) {
            this.isRetryable = true;
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }
}

