/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.servicenow.source.ServiceNowInputSplit;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class ServiceNowBaseRecordReader
extends RecordReader<NullWritable, StructuredRecord> {
    protected ServiceNowInputSplit split;
    protected int pos;
    protected List<Schema.Field> tableFields;
    protected Schema schema;
    protected String tableName;
    protected String tableNameField;
    protected List<Map<String, Object>> results;
    protected Iterator<Map<String, Object>> iterator;
    protected Map<String, Object> row;

    public void initialize(InputSplit split, TaskAttemptContext context) {
        this.split = (ServiceNowInputSplit)split;
        this.pos = 0;
    }

    public abstract boolean nextKeyValue() throws IOException;

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public abstract StructuredRecord getCurrentValue() throws IOException;

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.pos / (float)this.split.getLength();
    }

    public void close() throws IOException {
    }

    protected Object convertToValue(String fieldName, Schema fieldSchema, Map<String, Object> record) {
        Schema.Type fieldType = fieldSchema.getType();
        Object fieldValue = record.get(fieldName);
        switch (fieldType) {
            case STRING: {
                return this.convertToStringValue(fieldValue);
            }
            case DOUBLE: {
                return this.convertToDoubleValue(fieldValue);
            }
            case INT: {
                return this.convertToIntegerValue(fieldValue);
            }
            case BOOLEAN: {
                return this.convertToBooleanValue(fieldValue);
            }
            case UNION: {
                if (fieldSchema.isNullable()) {
                    return this.convertToValue(fieldName, fieldSchema.getNonNullable(), record);
                }
                throw new IllegalStateException(String.format("Field '%s' is of unexpected type '%s'. Declared 'complex UNION' types: %s", fieldName, record.get(fieldName).getClass().getSimpleName(), fieldSchema.getUnionSchemas()));
            }
        }
        throw new IllegalStateException(String.format("Record type '%s' is not supported for field '%s'", fieldType.name(), fieldName));
    }

    @VisibleForTesting
    String convertToStringValue(Object fieldValue) {
        return String.valueOf(fieldValue);
    }

    @VisibleForTesting
    Double convertToDoubleValue(Object fieldValue) {
        if (fieldValue instanceof String && Strings.isNullOrEmpty((String)String.valueOf(fieldValue))) {
            return null;
        }
        return Double.parseDouble(String.valueOf(fieldValue));
    }

    @VisibleForTesting
    Integer convertToIntegerValue(Object fieldValue) {
        if (fieldValue instanceof String && Strings.isNullOrEmpty((String)String.valueOf(fieldValue))) {
            return null;
        }
        return Integer.parseInt(String.valueOf(fieldValue));
    }

    @VisibleForTesting
    Boolean convertToBooleanValue(Object fieldValue) {
        if (fieldValue instanceof String && Strings.isNullOrEmpty((String)String.valueOf(fieldValue))) {
            return null;
        }
        return Boolean.parseBoolean(String.valueOf(fieldValue));
    }
}

