/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.servicenow.restapi.RestAPIResponse;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableAPIClientImpl;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableAPIRequestBuilder;
import io.cdap.plugin.servicenow.source.util.SourceValueType;
import io.cdap.plugin.servicenow.source.util.Util;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

public class ServiceNowBaseSourceConfig
extends PluginConfig {
    @Name(value="referenceName")
    @Description(value="This will be used to uniquely identify this source/sink for lineage, annotating metadata, etc.")
    public String referenceName;
    @Name(value="clientId")
    @Macro
    @Description(value=" The Client ID for ServiceNow Instance.")
    private String clientId;
    @Name(value="clientSecret")
    @Macro
    @Description(value="The Client Secret for ServiceNow Instance.")
    private String clientSecret;
    @Name(value="restApiEndpoint")
    @Macro
    @Description(value="The REST API Endpoint for ServiceNow Instance. For example, https://instance.service-now.com")
    private String restApiEndpoint;
    @Name(value="user")
    @Macro
    @Description(value="The user name for ServiceNow Instance.")
    private String user;
    @Name(value="password")
    @Macro
    @Description(value="The password for ServiceNow Instance.")
    private String password;
    @Name(value="valueType")
    @Macro
    @Description(value="The type of values to be returned.`Actual` -  will fetch the actual values from the ServiceNow tables`Display` - will fetch the display values from the ServiceNow tables.Default is Actual.")
    private String valueType;
    @Name(value="startDate")
    @Macro
    @Nullable
    @Description(value="The Start date to be used to filter the data. The format must be 'yyyy-MM-dd'.")
    private String startDate;
    @Name(value="endDate")
    @Macro
    @Nullable
    @Description(value="The End date to be used to filter the data. The format must be 'yyyy-MM-dd'.")
    private String endDate;
    @Name(value="tableNameField")
    @Macro
    @Nullable
    @Description(value="The name of the field that holds the table name. Must not be the name of any table column that will be read. Defaults to `tablename`. Note, the Table name field value will be ignored if the Mode is set to `Table`.")
    protected String tableNameField;

    public ServiceNowBaseSourceConfig(String referenceName, String tableNameField, String clientId, String clientSecret, String restApiEndpoint, String user, String password, String valueType, @Nullable String startDate, @Nullable String endDate) {
        this.referenceName = referenceName;
        this.tableNameField = tableNameField;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.restApiEndpoint = restApiEndpoint;
        this.user = user;
        this.password = password;
        this.valueType = valueType;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRestApiEndpoint() {
        return this.restApiEndpoint;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getStartDate() {
        return this.startDate;
    }

    @Nullable
    public String getEndDate() {
        return this.endDate;
    }

    public String getTableNameField() {
        return Strings.isNullOrEmpty((String)this.tableNameField) ? "tablename" : this.tableNameField;
    }

    public void validate(FailureCollector collector) {
        IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        this.validateCredentials(collector);
        this.validateValueType(collector);
        this.validateDateRange(collector);
    }

    public void validateCredentials(FailureCollector collector) {
        if (!this.shouldConnect()) {
            return;
        }
        if (Util.isNullOrEmpty(this.clientId)) {
            collector.addFailure("Client ID must be specified.", null).withConfigProperty("clientId");
        }
        if (Util.isNullOrEmpty(this.clientSecret)) {
            collector.addFailure("Client Secret must be specified.", null).withConfigProperty("clientSecret");
        }
        if (Util.isNullOrEmpty(this.restApiEndpoint)) {
            collector.addFailure("API Endpoint must be specified.", null).withConfigProperty("restApiEndpoint");
        }
        if (Util.isNullOrEmpty(this.user)) {
            collector.addFailure("User name must be specified.", null).withConfigProperty("user");
        }
        if (Util.isNullOrEmpty(this.password)) {
            collector.addFailure("Password must be specified.", null).withConfigProperty("password");
        }
        this.validateServiceNowConnection(collector);
    }

    @VisibleForTesting
    void validateServiceNowConnection(FailureCollector collector) {
        try {
            ServiceNowTableAPIClientImpl restApi = new ServiceNowTableAPIClientImpl(this);
            restApi.getAccessToken();
        }
        catch (Exception e) {
            collector.addFailure("Unable to connect to ServiceNow Instance.", "Ensure properties like Client ID, Client Secret, API Endpoint, User Name, Password are correct.").withConfigProperty("clientId").withConfigProperty("clientSecret").withConfigProperty("restApiEndpoint").withConfigProperty("user").withConfigProperty("password").withStacktrace(e.getStackTrace());
        }
    }

    @VisibleForTesting
    SourceValueType getValueType(FailureCollector collector) {
        SourceValueType type = this.getValueType();
        if (type != null) {
            return type;
        }
        collector.addFailure("Unsupported type value: " + this.valueType, String.format("Supported value types are: %s", SourceValueType.getSupportedValueTypes())).withConfigProperty("valueType");
        collector.getOrThrowException();
        return null;
    }

    @Nullable
    public SourceValueType getValueType() {
        return SourceValueType.fromValue(this.valueType).orElse(null);
    }

    private void validateValueType(FailureCollector collector) {
        if (this.containsMacro("valueType")) {
            return;
        }
        this.getValueType(collector);
    }

    private void validateDateRange(FailureCollector collector) {
        LocalDate toDate;
        if (this.containsMacro("startDate") || this.containsMacro("endDate")) {
            return;
        }
        if (!(Util.isNullOrEmpty(this.startDate) || Util.isNullOrEmpty(this.endDate) || Util.isValidDateFormat("yyyy-MM-dd", this.startDate) || Util.isValidDateFormat("yyyy-MM-dd", this.endDate))) {
            collector.addFailure("Invalid format for Start date. Correct Format: yyyy-MM-dd", null).withConfigProperty("startDate");
            collector.addFailure("Invalid format for End date. Correct Format:yyyy-MM-dd", null).withConfigProperty("endDate");
            return;
        }
        if (!Util.isNullOrEmpty(this.startDate) && !Util.isValidDateFormat("yyyy-MM-dd", this.startDate)) {
            collector.addFailure("Invalid format for Start date. Correct Format: yyyy-MM-dd", null).withConfigProperty("startDate");
            return;
        }
        if (!Util.isNullOrEmpty(this.endDate) && !Util.isValidDateFormat("yyyy-MM-dd", this.endDate)) {
            collector.addFailure("Invalid format for End date. Correct Format:yyyy-MM-dd", null).withConfigProperty("endDate");
            return;
        }
        if (Util.isNullOrEmpty(this.startDate) || Util.isNullOrEmpty(this.endDate)) {
            return;
        }
        LocalDate fromDate = LocalDate.parse(this.startDate);
        long noOfDays = ChronoUnit.DAYS.between(fromDate, toDate = LocalDate.parse(this.endDate));
        if (noOfDays < 0L) {
            collector.addFailure("End date must be greater than Start date.", null).withConfigProperty("startDate").withConfigProperty("endDate");
        }
    }

    public boolean shouldConnect() {
        return !this.containsMacro("clientId") && !this.containsMacro("clientSecret") && !this.containsMacro("restApiEndpoint") && !this.containsMacro("user") && !this.containsMacro("password");
    }

    public boolean shouldGetSchema() {
        return !this.containsMacro("queryMode") && !this.containsMacro("applicationName") && !this.containsMacro("tableNameField") && !this.containsMacro("tableName") && !this.containsMacro("tableNames") && this.shouldConnect() && !this.containsMacro("valueType");
    }

    void validateTable(String tableName, FailureCollector collector) {
        ServiceNowTableAPIRequestBuilder requestBuilder = new ServiceNowTableAPIRequestBuilder(this.getRestApiEndpoint(), tableName).setExcludeReferenceLink(true).setDisplayValue(this.getValueType()).setLimit(1);
        RestAPIResponse apiResponse = null;
        ServiceNowTableAPIClientImpl serviceNowTableAPIClient = new ServiceNowTableAPIClientImpl(this);
        try {
            String accessToken = serviceNowTableAPIClient.getAccessToken();
            requestBuilder.setAuthHeader(accessToken);
            requestBuilder.setResponseHeaders("X-Total-Count");
            apiResponse = serviceNowTableAPIClient.executeGet(requestBuilder.build());
            if (!apiResponse.isSuccess()) {
                if (apiResponse.getHttpStatus() == 400) {
                    collector.addFailure("Bad Request. Table: " + tableName + " is invalid.", "");
                }
            } else if (serviceNowTableAPIClient.parseResponseToResultListOfMap(apiResponse.getResponseBody()).isEmpty()) {
                collector.addFailure("Table: " + tableName + " is empty.", "");
            }
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            collector.addFailure("Unable to connect to ServiceNow Instance.", "Ensure properties like Client ID, Client Secret, API Endpoint, User Name, Password are correct.").withConfigProperty("clientId").withConfigProperty("clientSecret").withConfigProperty("restApiEndpoint").withConfigProperty("user").withConfigProperty("password");
        }
    }
}

