/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.servicenow.source.ServiceNowInputSplit;
import io.cdap.plugin.servicenow.source.ServiceNowJobConfiguration;
import io.cdap.plugin.servicenow.source.ServiceNowRecordReader;
import io.cdap.plugin.servicenow.source.ServiceNowSourceConfig;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableAPIClientImpl;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableDataResponse;
import io.cdap.plugin.servicenow.source.util.SchemaBuilder;
import io.cdap.plugin.servicenow.source.util.ServiceNowColumn;
import io.cdap.plugin.servicenow.source.util.ServiceNowTableInfo;
import io.cdap.plugin.servicenow.source.util.SourceQueryMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowInputFormat
extends InputFormat<NullWritable, StructuredRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNowInputFormat.class);

    public static List<ServiceNowTableInfo> setInput(Configuration jobConfig, SourceQueryMode mode, ServiceNowSourceConfig conf) {
        ServiceNowJobConfiguration jobConf = new ServiceNowJobConfiguration(jobConfig);
        jobConf.setPluginConfiguration(conf);
        List<ServiceNowTableInfo> tableInfos = ServiceNowInputFormat.fetchTableInfo(mode, conf);
        jobConf.setTableInfos(tableInfos);
        return tableInfos;
    }

    static List<ServiceNowTableInfo> fetchTableInfo(SourceQueryMode mode, ServiceNowSourceConfig conf) {
        if (mode == SourceQueryMode.TABLE) {
            ServiceNowTableInfo tableInfo = ServiceNowInputFormat.getTableMetaData(conf.getTableName(), conf);
            return tableInfo == null ? Collections.emptyList() : Collections.singletonList(tableInfo);
        }
        ArrayList<ServiceNowTableInfo> tableInfos = new ArrayList<ServiceNowTableInfo>();
        List<String> tableNames = conf.getApplicationName().getTableNames();
        for (String tableName : tableNames) {
            ServiceNowTableInfo tableInfo = ServiceNowInputFormat.getTableMetaData(tableName, conf);
            if (tableInfo == null) continue;
            tableInfos.add(tableInfo);
        }
        return tableInfos;
    }

    private static ServiceNowTableInfo getTableMetaData(String tableName, ServiceNowSourceConfig conf) {
        ServiceNowTableAPIClientImpl restApi = new ServiceNowTableAPIClientImpl(conf);
        ServiceNowTableDataResponse response = restApi.fetchTableSchema(tableName, conf.getStartDate(), conf.getEndDate(), true);
        if (response == null) {
            return null;
        }
        List<ServiceNowColumn> columns = response.getColumns();
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        Schema schema = SchemaBuilder.constructSchema(tableName, columns);
        LOG.debug("table {}, rows = {}", (Object)tableName, (Object)response.getTotalRecordCount());
        return new ServiceNowTableInfo(tableName, schema, response.getTotalRecordCount());
    }

    public List<InputSplit> getSplits(JobContext jobContext) {
        ServiceNowJobConfiguration jobConfig = new ServiceNowJobConfiguration(jobContext.getConfiguration());
        List<ServiceNowTableInfo> tableInfos = jobConfig.getTableInfos();
        ArrayList<InputSplit> resultSplits = new ArrayList<InputSplit>();
        for (ServiceNowTableInfo tableInfo : tableInfos) {
            String tableName = tableInfo.getTableName();
            int totalRecords = tableInfo.getRecordCount();
            if (totalRecords <= 5000) {
                resultSplits.add(new ServiceNowInputSplit(tableName, 0));
                continue;
            }
            int pages = tableInfo.getRecordCount() / 5000;
            if (tableInfo.getRecordCount() % 5000 > 0) {
                ++pages;
            }
            int offset = 0;
            for (int page = 1; page <= pages; ++page) {
                resultSplits.add(new ServiceNowInputSplit(tableName, offset));
                offset += 5000;
            }
        }
        return resultSplits;
    }

    public RecordReader<NullWritable, StructuredRecord> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        ServiceNowJobConfiguration jobConfig = new ServiceNowJobConfiguration(taskAttemptContext.getConfiguration());
        ServiceNowSourceConfig pluginConf = jobConfig.getPluginConf();
        return new ServiceNowRecordReader(pluginConf);
    }
}

