/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class ServiceNowInputSplit
extends InputSplit
implements Writable {
    private String tableName;
    private int offset;

    public ServiceNowInputSplit() {
    }

    public ServiceNowInputSplit(String tableName, int offset) {
        this.tableName = tableName;
        this.offset = offset;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getOffset() {
        return this.offset;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.tableName);
        dataOutput.writeInt(this.offset);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.tableName = dataInput.readUTF();
        this.offset = dataInput.readInt();
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }
}

