/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.cdap.plugin.servicenow.source.ServiceNowMultiSourceConfig;
import io.cdap.plugin.servicenow.source.ServiceNowSourceConfig;
import io.cdap.plugin.servicenow.source.util.ServiceNowTableInfo;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class ServiceNowJobConfiguration {
    private static final String PLUGIN_CONF_FIELD = "servicenow.plugin.conf";
    private static final String INFO_FIELD = "servicenow.table.info";
    private static final Type PLUGIN_CONF_TYPE = new TypeToken<ServiceNowSourceConfig>(){}.getType();
    private static final Type MULTI_SOURCE_PLUGIN_CONF_TYPE = new TypeToken<ServiceNowMultiSourceConfig>(){}.getType();
    private static final Type INFO_TYPE = new TypeToken<List<ServiceNowTableInfo>>(){}.getType();
    private static final Gson GSON = new Gson();
    private Configuration conf;

    public ServiceNowJobConfiguration(Configuration job) {
        this.conf = job;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setPluginConfiguration(ServiceNowSourceConfig conf) {
        this.set(PLUGIN_CONF_FIELD, GSON.toJson((Object)conf));
    }

    public void setMultiSourcePluginConfiguration(ServiceNowMultiSourceConfig conf) {
        this.set(PLUGIN_CONF_FIELD, GSON.toJson((Object)conf));
    }

    public ServiceNowSourceConfig getPluginConf() {
        return (ServiceNowSourceConfig)((Object)GSON.fromJson(this.getConf().get(PLUGIN_CONF_FIELD), PLUGIN_CONF_TYPE));
    }

    public ServiceNowMultiSourceConfig getMultiSourcePluginConf() {
        return (ServiceNowMultiSourceConfig)((Object)GSON.fromJson(this.getConf().get(PLUGIN_CONF_FIELD), MULTI_SOURCE_PLUGIN_CONF_TYPE));
    }

    public List<ServiceNowTableInfo> getTableInfos() {
        return (List)GSON.fromJson(this.getConf().get(INFO_FIELD), INFO_TYPE);
    }

    public void setTableInfos(List<ServiceNowTableInfo> infoList) {
        this.set(INFO_FIELD, GSON.toJson(infoList));
    }

    private void set(String key, String value) {
        this.getConf().set(key, value);
    }
}

