/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import com.google.common.base.Strings;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.servicenow.source.ServiceNowInputSplit;
import io.cdap.plugin.servicenow.source.ServiceNowJobConfiguration;
import io.cdap.plugin.servicenow.source.ServiceNowMultiRecordReader;
import io.cdap.plugin.servicenow.source.ServiceNowMultiSourceConfig;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableAPIClientImpl;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableDataResponse;
import io.cdap.plugin.servicenow.source.util.SchemaBuilder;
import io.cdap.plugin.servicenow.source.util.ServiceNowColumn;
import io.cdap.plugin.servicenow.source.util.ServiceNowTableInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowMultiInputFormat
extends InputFormat<NullWritable, StructuredRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNowMultiInputFormat.class);

    public static Set<ServiceNowTableInfo> setInput(Configuration jobConfig, ServiceNowMultiSourceConfig conf) {
        ServiceNowJobConfiguration jobConf = new ServiceNowJobConfiguration(jobConfig);
        jobConf.setMultiSourcePluginConfiguration(conf);
        Set<ServiceNowTableInfo> tableInfos = ServiceNowMultiInputFormat.fetchTablesInfo(conf);
        jobConf.setTableInfos(tableInfos.stream().collect(Collectors.toList()));
        return tableInfos;
    }

    static Set<ServiceNowTableInfo> fetchTablesInfo(ServiceNowMultiSourceConfig conf) {
        LinkedHashSet<ServiceNowTableInfo> tablesInfos = new LinkedHashSet<ServiceNowTableInfo>();
        Set<String> tableNames = ServiceNowMultiInputFormat.getList(conf.getTableNames());
        for (String tableName : tableNames) {
            ServiceNowTableInfo tableInfo = ServiceNowMultiInputFormat.getTableMetaData(tableName, conf);
            if (tableInfo == null) continue;
            tablesInfos.add(tableInfo);
        }
        return tablesInfos;
    }

    private static ServiceNowTableInfo getTableMetaData(String tableName, ServiceNowMultiSourceConfig conf) {
        ServiceNowTableAPIClientImpl restApi = new ServiceNowTableAPIClientImpl(conf);
        ServiceNowTableDataResponse response = restApi.fetchTableSchema(tableName, conf.getStartDate(), conf.getEndDate(), true);
        if (response == null) {
            return null;
        }
        List<ServiceNowColumn> columns = response.getColumns();
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        Schema schema = SchemaBuilder.constructSchema(tableName, columns);
        LOG.debug("table {}, rows = {}", (Object)tableName, (Object)response.getTotalRecordCount());
        return new ServiceNowTableInfo(tableName, schema, response.getTotalRecordCount());
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        ServiceNowJobConfiguration jobConfig = new ServiceNowJobConfiguration(jobContext.getConfiguration());
        List<ServiceNowTableInfo> tableInfos = jobConfig.getTableInfos();
        ArrayList<InputSplit> resultSplits = new ArrayList<InputSplit>();
        for (ServiceNowTableInfo tableInfo : tableInfos) {
            String tableName = tableInfo.getTableName();
            int totalRecords = tableInfo.getRecordCount();
            int pages = tableInfo.getRecordCount() / 5000;
            if (tableInfo.getRecordCount() % 5000 > 0) {
                ++pages;
            }
            int offset = 0;
            for (int page = 1; page <= pages; ++page) {
                resultSplits.add(new ServiceNowInputSplit(tableName, offset));
                offset += 5000;
            }
        }
        return resultSplits;
    }

    public RecordReader<NullWritable, StructuredRecord> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        ServiceNowJobConfiguration jobConfig = new ServiceNowJobConfiguration(taskAttemptContext.getConfiguration());
        ServiceNowMultiSourceConfig pluginConf = jobConfig.getMultiSourcePluginConf();
        return new ServiceNowMultiRecordReader(pluginConf);
    }

    public static Set<String> getList(String value) {
        return Strings.isNullOrEmpty((String)value) ? Collections.emptySet() : Stream.of(value.split(",")).map(String::trim).filter(name -> !name.isEmpty()).collect(Collectors.toSet());
    }
}

