/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.servicenow.source.ServiceNowBaseSourceConfig;
import io.cdap.plugin.servicenow.source.ServiceNowMultiInputFormat;
import io.cdap.plugin.servicenow.source.util.Util;
import java.util.Set;
import javax.annotation.Nullable;

public class ServiceNowMultiSourceConfig
extends ServiceNowBaseSourceConfig {
    @Name(value="tableNames")
    @Macro
    @Description(value="The names of the ServiceNow tables from which data is fetched")
    private String tableNames;

    public ServiceNowMultiSourceConfig(String referenceName, String tableNameField, String clientId, String clientSecret, String restApiEndpoint, String user, String password, String valueType, @Nullable String startDate, @Nullable String endDate, String tableNames) {
        super(referenceName, tableNameField, clientId, clientSecret, restApiEndpoint, user, password, valueType, startDate, endDate);
        this.tableNames = tableNames;
    }

    @Nullable
    public String getTableNames() {
        return this.tableNames;
    }

    @Override
    public void validate(FailureCollector collector) {
        super.validate(collector);
        this.validateTableNames(collector);
        this.validateTableNameField(collector);
    }

    private void validateTableNameField(FailureCollector collector) {
        if (this.containsMacro("tableNameField")) {
            return;
        }
        if (Util.isNullOrEmpty(this.tableNameField)) {
            collector.addFailure("Table name field must be specified.", null).withConfigProperty("tableNameField");
        }
    }

    @VisibleForTesting
    void validateTableNames(FailureCollector collector) {
        if (this.containsMacro("tableNames")) {
            return;
        }
        if (!this.shouldConnect()) {
            return;
        }
        if (Util.isNullOrEmpty(this.tableNames)) {
            collector.addFailure("Table names must be specified.", null).withConfigProperty("tableNames");
        } else {
            Set<String> tableNames = ServiceNowMultiInputFormat.getList(this.getTableNames());
            for (String tableName : tableNames) {
                this.validateTable(tableName, collector);
            }
        }
    }
}

