/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.servicenow.source.ServiceNowBaseRecordReader;
import io.cdap.plugin.servicenow.source.ServiceNowSourceConfig;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableAPIClientImpl;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableDataResponse;
import io.cdap.plugin.servicenow.source.util.SchemaBuilder;
import io.cdap.plugin.servicenow.source.util.SourceQueryMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowRecordReader
extends ServiceNowBaseRecordReader {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNowRecordReader.class);
    private final ServiceNowSourceConfig pluginConf;

    ServiceNowRecordReader(ServiceNowSourceConfig pluginConf) {
        this.pluginConf = pluginConf;
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        try {
            if (this.results == null) {
                this.fetchData();
            }
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.row = (Map)this.iterator.next();
            ++this.pos;
        }
        catch (Exception e) {
            LOG.error("Error in nextKeyValue", (Throwable)e);
            throw new IOException("Exception in nextKeyValue", e);
        }
        return true;
    }

    @Override
    public StructuredRecord getCurrentValue() throws IOException {
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)this.schema);
        if (this.pluginConf.getQueryMode() == SourceQueryMode.REPORTING) {
            recordBuilder.set(this.tableNameField, (Object)this.tableName);
        }
        try {
            for (Schema.Field field : this.tableFields) {
                String fieldName = field.getName();
                Object fieldValue = this.convertToValue(fieldName, field.getSchema(), this.row);
                recordBuilder.set(fieldName, fieldValue);
            }
        }
        catch (Exception e) {
            LOG.error("Error decoding row from table " + this.tableName, (Throwable)e);
            throw new IOException("Error decoding row from table " + this.tableName, e);
        }
        return recordBuilder.build();
    }

    private void fetchData() {
        this.tableName = this.split.getTableName();
        this.tableNameField = this.pluginConf.getTableNameField();
        ServiceNowTableAPIClientImpl restApi = new ServiceNowTableAPIClientImpl(this.pluginConf);
        this.results = restApi.fetchTableRecordsRetryableMode(this.tableName, this.pluginConf.getStartDate(), this.pluginConf.getEndDate(), this.split.getOffset(), 5000);
        LOG.debug("Results size={}", (Object)this.results.size());
        if (!this.results.isEmpty()) {
            this.fetchSchema(restApi);
        }
        this.iterator = this.results.iterator();
    }

    private void fetchSchema(ServiceNowTableAPIClientImpl restApi) {
        ServiceNowTableDataResponse response = restApi.fetchTableSchema(this.tableName, null, null, false);
        if (response == null) {
            return;
        }
        Schema tempSchema = SchemaBuilder.constructSchema(this.tableName, response.getColumns());
        this.tableFields = tempSchema.getFields();
        ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>(this.tableFields);
        if (this.pluginConf.getQueryMode() == SourceQueryMode.REPORTING) {
            schemaFields.add(Schema.Field.of((String)this.tableNameField, (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        }
        this.schema = Schema.recordOf((String)this.tableName, schemaFields);
    }
}

