/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.servicenow.source.ServiceNowBaseSourceConfig;
import io.cdap.plugin.servicenow.source.util.SourceApplication;
import io.cdap.plugin.servicenow.source.util.SourceQueryMode;
import io.cdap.plugin.servicenow.source.util.Util;
import java.util.Optional;
import javax.annotation.Nullable;

public class ServiceNowSourceConfig
extends ServiceNowBaseSourceConfig {
    @Name(value="queryMode")
    @Macro
    @Description(value="Mode of query. The mode can be one of two values: `Reporting` - will allow user to choose application for which data will be fetched for all tables, `Table` - will allow user to enter table name for which data will be fetched.")
    private String queryMode;
    @Name(value="applicationName")
    @Macro
    @Nullable
    @Description(value="Application name for which data to be fetched. The application can be one of three values: `Contract Management` - will fetch data for all tables under Contract Management application, `Product Catalog` - will fetch data for all tables under Product Catalog application, `Procurement` - will fetch data for all tables under Procurement application. Note, the Application name value will be ignored if the Mode is set to `Table`.")
    private String applicationName;
    @Name(value="tableName")
    @Macro
    @Nullable
    @Description(value="The name of the ServiceNow table from which data to be fetched. Note, the Table name value will be ignored if the Mode is set to `Reporting`.")
    private String tableName;

    public ServiceNowSourceConfig(String referenceName, String queryMode, @Nullable String applicationName, @Nullable String tableNameField, @Nullable String tableName, String clientId, String clientSecret, String restApiEndpoint, String user, String password, String valueType, @Nullable String startDate, @Nullable String endDate) {
        super(referenceName, tableNameField, clientId, clientSecret, restApiEndpoint, user, password, valueType, startDate, endDate);
        this.referenceName = referenceName;
        this.queryMode = queryMode;
        this.applicationName = applicationName;
        this.tableName = tableName;
    }

    public SourceQueryMode getQueryMode(FailureCollector collector) {
        SourceQueryMode mode = this.getQueryMode();
        if (mode != null) {
            return mode;
        }
        collector.addFailure("Unsupported query mode value: " + this.queryMode, String.format("Supported modes are: %s", SourceQueryMode.getSupportedModes())).withConfigProperty("queryMode");
        collector.getOrThrowException();
        return null;
    }

    public SourceQueryMode getQueryMode() {
        Optional<SourceQueryMode> sourceQueryMode = SourceQueryMode.fromValue(this.queryMode);
        return sourceQueryMode.isPresent() ? sourceQueryMode.get() : null;
    }

    public SourceApplication getApplicationName(FailureCollector collector) {
        SourceApplication application = this.getApplicationName();
        if (application != null) {
            return application;
        }
        collector.addFailure("Unsupported application name value: " + this.applicationName, String.format("Supported applications are: %s", SourceApplication.getSupportedApplications())).withConfigProperty("applicationName");
        collector.getOrThrowException();
        return null;
    }

    @Nullable
    public SourceApplication getApplicationName() {
        Optional<SourceApplication> sourceApplication = SourceApplication.fromValue(this.applicationName);
        return sourceApplication.isPresent() ? sourceApplication.get() : null;
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void validate(FailureCollector collector) {
        super.validate(collector);
        this.validateQueryMode(collector);
    }

    private void validateQueryMode(FailureCollector collector) {
        if (this.containsMacro("queryMode")) {
            return;
        }
        SourceQueryMode mode = this.getQueryMode(collector);
        if (mode == SourceQueryMode.REPORTING) {
            this.validateReportingQueryMode(collector);
        } else {
            this.validateTableQueryMode(collector);
        }
    }

    private void validateReportingQueryMode(FailureCollector collector) {
        if (!this.containsMacro("applicationName")) {
            this.getApplicationName(collector);
        }
        if (this.containsMacro("tableNameField")) {
            return;
        }
        if (Util.isNullOrEmpty(this.tableNameField)) {
            collector.addFailure("Table name field must be specified.", null).withConfigProperty("tableNameField");
        }
    }

    private void validateTableQueryMode(FailureCollector collector) {
        if (this.containsMacro("tableName")) {
            return;
        }
        if (!this.shouldConnect()) {
            return;
        }
        if (Util.isNullOrEmpty(this.tableName)) {
            collector.addFailure("Table name must be specified.", null).withConfigProperty("tableName");
        } else {
            this.validateTable(this.tableName, collector);
        }
    }
}

