/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source.apiclient;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.cdap.plugin.servicenow.restapi.RestAPIClient;
import io.cdap.plugin.servicenow.restapi.RestAPIResponse;
import io.cdap.plugin.servicenow.source.ServiceNowBaseSourceConfig;
import io.cdap.plugin.servicenow.source.apiclient.RetryableException;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableAPIRequestBuilder;
import io.cdap.plugin.servicenow.source.apiclient.ServiceNowTableDataResponse;
import io.cdap.plugin.servicenow.source.util.ServiceNowColumn;
import io.cdap.plugin.servicenow.source.util.Util;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowTableAPIClientImpl
extends RestAPIClient {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNowTableAPIClientImpl.class);
    private static final String DATE_RANGE_TEMPLATE = "%sBETWEENjavascript:gs.dateGenerate('%s','start')@javascript:gs.dateGenerate('%s','end')";
    private static final String FIELD_CREATED_ON = "sys_created_on";
    private static final String FIELD_UPDATED_ON = "sys_updated_on";
    private static final String OAUTH_URL_TEMPLATE = "%s/oauth_token.do";
    private ServiceNowBaseSourceConfig conf;

    public ServiceNowTableAPIClientImpl(ServiceNowBaseSourceConfig conf) {
        this.conf = conf;
    }

    public String getAccessToken() throws OAuthSystemException, OAuthProblemException {
        return this.generateAccessToken(String.format(OAUTH_URL_TEMPLATE, this.conf.getRestApiEndpoint()), this.conf.getClientId(), this.conf.getClientSecret(), this.conf.getUser(), this.conf.getPassword());
    }

    public List<Map<String, Object>> fetchTableRecords(String tableName, String startDate, String endDate, int offset, int limit) {
        ServiceNowTableAPIRequestBuilder requestBuilder = new ServiceNowTableAPIRequestBuilder(this.conf.getRestApiEndpoint(), tableName).setExcludeReferenceLink(true).setDisplayValue(this.conf.getValueType()).setLimit(limit);
        if (offset > 0) {
            requestBuilder.setOffset(offset);
        }
        this.applyDateRangeToRequest(requestBuilder, startDate, endDate);
        RestAPIResponse apiResponse = null;
        try {
            String accessToken = this.getAccessToken();
            requestBuilder.setAuthHeader(accessToken);
            apiResponse = this.executeGet(requestBuilder.build());
            if (!apiResponse.isSuccess()) {
                if (apiResponse.isRetryable()) {
                    throw new RetryableException();
                }
                return Collections.emptyList();
            }
            return this.parseResponseToResultListOfMap(apiResponse.getResponseBody());
        }
        catch (OAuthSystemException e) {
            throw new RetryableException();
        }
        catch (OAuthProblemException e) {
            LOG.error("Error in fetchTableRecords", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void createRecord(String tableName, HttpEntity entity) {
        ServiceNowTableAPIRequestBuilder requestBuilder = new ServiceNowTableAPIRequestBuilder(this.conf.getRestApiEndpoint(), tableName);
        RestAPIResponse apiResponse = null;
        try {
            String accessToken = this.getAccessToken();
            requestBuilder.setAuthHeader(accessToken);
            requestBuilder.setAcceptHeader("application/json");
            requestBuilder.setContentTypeHeader("application/json");
            requestBuilder.setEntity(entity);
            apiResponse = this.executePost(requestBuilder.build());
            if (!apiResponse.isSuccess()) {
                LOG.error("Error - {}", (Object)this.getErrorMessage(apiResponse.getResponseBody()));
            } else {
                LOG.info(apiResponse.getResponseBody().toString());
            }
        }
        catch (UnsupportedEncodingException | OAuthProblemException | OAuthSystemException e) {
            LOG.error("Error in creating a new record", e);
            throw new RuntimeException("Error in creating a new record");
        }
    }

    public ServiceNowTableDataResponse fetchTableSchema(String tableName, String startDate, String endDate, boolean fetchRecordCount) {
        return this.fetchTableSchemaUsingFirstRecord(tableName, startDate, endDate, fetchRecordCount);
    }

    private ServiceNowTableDataResponse fetchTableSchemaUsingFirstRecord(String tableName, String startDate, String endDate, boolean fetchRecordCount) {
        ServiceNowTableAPIRequestBuilder requestBuilder = new ServiceNowTableAPIRequestBuilder(this.conf.getRestApiEndpoint(), tableName).setExcludeReferenceLink(true).setDisplayValue(this.conf.getValueType()).setLimit(1);
        this.applyDateRangeToRequest(requestBuilder, startDate, endDate);
        RestAPIResponse apiResponse = null;
        try {
            String accessToken = this.getAccessToken();
            requestBuilder.setAuthHeader(accessToken);
            if (fetchRecordCount) {
                requestBuilder.setResponseHeaders("X-Total-Count");
            }
            if (!(apiResponse = this.executeGet(requestBuilder.build())).isSuccess()) {
                LOG.error("Error - {}", (Object)this.getErrorMessage(apiResponse.getResponseBody()));
                return null;
            }
            ServiceNowTableDataResponse tableDataResponse = new ServiceNowTableDataResponse();
            List<Map<String, Object>> result = this.parseResponseToResultListOfMap(apiResponse.getResponseBody());
            ArrayList<ServiceNowColumn> columns = new ArrayList<ServiceNowColumn>();
            if (result != null && !result.isEmpty()) {
                Map<String, Object> firstRecord = result.get(0);
                for (String key : firstRecord.keySet()) {
                    columns.add(new ServiceNowColumn(key, "string"));
                }
            }
            tableDataResponse.setColumns(columns);
            if (fetchRecordCount) {
                tableDataResponse.setTotalRecordCount(this.getRecordCountFromHeader(apiResponse));
            }
            return tableDataResponse;
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            LOG.error("Error in fetchFirstRecordFromTable", e);
            return null;
        }
    }

    private void applyDateRangeToRequest(ServiceNowTableAPIRequestBuilder requestBuilder, String startDate, String endDate) {
        String dateRange = this.generateDateRangeQuery(startDate, endDate);
        if (!Strings.isNullOrEmpty((String)dateRange)) {
            requestBuilder.setQuery(dateRange);
        }
    }

    private String generateDateRangeQuery(String startDate, String endDate) {
        if (Util.isNullOrEmpty(startDate) || Util.isNullOrEmpty(endDate)) {
            return "";
        }
        String dateRange = "";
        try {
            String createdOnDateRange = String.format(DATE_RANGE_TEMPLATE, FIELD_CREATED_ON, startDate, endDate);
            String updatedOnDateRange = String.format(DATE_RANGE_TEMPLATE, FIELD_UPDATED_ON, startDate, endDate);
            dateRange = String.format("%s^OR%s", createdOnDateRange, updatedOnDateRange);
        }
        catch (Exception e) {
            LOG.error("Error in generateDateRangeQuery, hence ignoring the date range", (Throwable)e);
        }
        return dateRange;
    }

    private int getRecordCountFromHeader(RestAPIResponse apiResponse) {
        String headerValue = apiResponse.getHeaders().get("X-Total-Count");
        return Strings.isNullOrEmpty((String)headerValue) ? 0 : Integer.parseInt(headerValue);
    }

    public List<Map<String, Object>> parseResponseToResultListOfMap(String responseBody) {
        Gson gson = new Gson();
        JsonObject jo = (JsonObject)gson.fromJson(responseBody, JsonObject.class);
        JsonArray ja = jo.getAsJsonArray("result");
        Type type = new TypeToken<List<Map<String, Object>>>(){}.getType();
        return (List)gson.fromJson((JsonElement)ja, type);
    }

    private String getErrorMessage(String responseBody) {
        try {
            Gson gson = new Gson();
            JsonObject jo = (JsonObject)gson.fromJson(responseBody, JsonObject.class);
            return jo.getAsJsonObject("error").get("message").getAsString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public List<Map<String, Object>> fetchTableRecordsRetryableMode(String tableName, String startDate, String endDate, int offset, int limit) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Callable<Boolean> fetchRecords = () -> {
            results.addAll(this.fetchTableRecords(tableName, startDate, endDate, offset, limit));
            return true;
        };
        Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(RetryableException.class).withWaitStrategy(WaitStrategies.exponentialWait((long)120000L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)5)).build();
        try {
            retryer.call(fetchRecords);
        }
        catch (RetryException | ExecutionException e) {
            LOG.error("Data Recovery failed for batch {} to {}.", (Object)offset, (Object)(offset + limit));
        }
        return results;
    }
}

