/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source.apiclient;

import com.google.common.base.Joiner;
import io.cdap.plugin.servicenow.restapi.RestAPIRequest;
import io.cdap.plugin.servicenow.source.util.SourceValueType;
import java.net.URLEncoder;
import java.util.Arrays;

public class ServiceNowTableAPIRequestBuilder
extends RestAPIRequest.Builder {
    private static final String TABLE_API_URL_TEMPLATE = "%s/api/now/table/%s";

    public ServiceNowTableAPIRequestBuilder(String instanceBaseUrl, String tableName) {
        super(String.format(TABLE_API_URL_TEMPLATE, instanceBaseUrl, tableName));
    }

    public ServiceNowTableAPIRequestBuilder setQuery(String query) {
        try {
            this.parameters.put("sysparm_query", URLEncoder.encode(query, "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public ServiceNowTableAPIRequestBuilder setOffset(int offset) {
        this.parameters.put("sysparm_offset", String.valueOf(offset));
        return this;
    }

    public ServiceNowTableAPIRequestBuilder setLimit(int limit) {
        this.parameters.put("sysparm_limit", String.valueOf(limit));
        return this;
    }

    public ServiceNowTableAPIRequestBuilder setFields(String ... fields) {
        if (fields == null || fields.length == 0) {
            return this;
        }
        try {
            this.parameters.put("sysparm_fields", URLEncoder.encode(Joiner.on((char)',').join(Arrays.asList(fields)), "UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public ServiceNowTableAPIRequestBuilder setDisplayValue(SourceValueType displayValue) {
        this.parameters.put("sysparm_display_value", displayValue.getValue());
        return this;
    }

    public ServiceNowTableAPIRequestBuilder setExcludeReferenceLink(boolean excludeRefLink) {
        this.parameters.put("sysparm_exclude_reference_link", String.valueOf(excludeRefLink));
        return this;
    }
}

