/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source.util;

import com.google.common.base.Strings;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.servicenow.source.util.ServiceNowColumn;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SchemaBuilder {
    public static Schema constructSchema(String tableName, List<ServiceNowColumn> columns) {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        List<Schema.Field> fields = schemaBuilder.constructSchemaFields(columns);
        return Schema.recordOf((String)tableName, fields);
    }

    private List<Schema.Field> constructSchemaFields(List<ServiceNowColumn> columns) {
        return columns.stream().map(o -> this.transformToField((ServiceNowColumn)o)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Schema.Field transformToField(ServiceNowColumn column) {
        String name = column.getFieldName();
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        Schema schema = this.createSchema(column);
        if (schema == null) {
            return null;
        }
        return Schema.Type.NULL == schema.getType() ? Schema.Field.of((String)name, (Schema)schema) : Schema.Field.of((String)name, (Schema)Schema.nullableOf((Schema)schema));
    }

    private Schema createSchema(ServiceNowColumn column) {
        switch (column.getTypeName().toLowerCase()) {
            case "decimal": {
                return Schema.of((Schema.Type)Schema.Type.DOUBLE);
            }
            case "integer": {
                return Schema.of((Schema.Type)Schema.Type.INT);
            }
            case "boolean": {
                return Schema.of((Schema.Type)Schema.Type.BOOLEAN);
            }
        }
        return Schema.of((Schema.Type)Schema.Type.STRING);
    }
}

