/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceApplication {
    CONTRACT_MANAGEMENT("Contract Management", Arrays.asList("clm_m2m_contract_asset", "clm_m2m_rate_card_asset", "clm_condition_checker", "clm_condition_check", "ast_contract", "clm_contract_history", "clm_terms_and_conditions", "clm_m2m_contract_and_terms", "clm_m2m_contract_user")),
    PRODUCT_CATALOG("Product Catalog", Arrays.asList("pc_hardware_cat_item", "pc_product_cat_item", "pc_software_cat_item", "pc_vendor_cat_item")),
    PROCUREMENT("Procurement", Arrays.asList("proc_po", "proc_po_item", "proc_rec_slip", "proc_rec_slip_item"));

    private final String value;
    private final List<String> tableNames;

    private SourceApplication(String value, List<String> tableNames) {
        this.value = value;
        this.tableNames = tableNames;
    }

    public static Optional<SourceApplication> fromValue(String stringValue) {
        return Stream.of(SourceApplication.values()).filter(keyType -> keyType.value.equalsIgnoreCase(stringValue)).findAny();
    }

    public static String getSupportedApplications() {
        return Arrays.stream(SourceApplication.values()).map(SourceApplication::getValue).collect(Collectors.joining(", "));
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }
}

