/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceQueryMode {
    REPORTING("Reporting"),
    TABLE("Table");

    private final String value;

    private SourceQueryMode(String value) {
        this.value = value;
    }

    public static Optional<SourceQueryMode> fromValue(String stringValue) {
        return Stream.of(SourceQueryMode.values()).filter(keyType -> keyType.value.equalsIgnoreCase(stringValue)).findAny();
    }

    public static String getSupportedModes() {
        return Arrays.stream(SourceQueryMode.values()).map(SourceQueryMode::getValue).collect(Collectors.joining(", "));
    }

    public String getValue() {
        return this.value;
    }
}

