/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.servicenow.source.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceValueType {
    SHOW_ACTUAL_VALUE("Actual", "false"),
    SHOW_DISPLAY_VALUE("Display", "true");

    private final String valueType;
    private final String value;

    private SourceValueType(String valueType, String value) {
        this.valueType = valueType;
        this.value = value;
    }

    public static Optional<SourceValueType> fromValue(String stringValue) {
        return Stream.of(SourceValueType.values()).filter(keyType -> keyType.valueType.equalsIgnoreCase(stringValue)).findAny();
    }

    public static String getSupportedValueTypes() {
        return Arrays.stream(SourceValueType.values()).map(SourceValueType::getValueType).collect(Collectors.joining(", "));
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getValue() {
        return this.value;
    }
}

