/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.twill.api.TwillRunResources;
import org.apache.twill.api.logging.LogEntry;

public class DefaultTwillRunResources
implements TwillRunResources {
    private final String containerId;
    private final int instanceId;
    private final int virtualCores;
    private final int memoryMB;
    private final int maxHeapMemoryMB;
    private final String host;
    private final Integer debugPort;
    private final Map<String, LogEntry.Level> logLevels;

    public DefaultTwillRunResources(int instanceId, String containerId, int cores, int memoryMB, int maxHeapMemoryMB, String host, Integer debugPort) {
        this(instanceId, containerId, cores, memoryMB, maxHeapMemoryMB, host, debugPort, Collections.emptyMap());
    }

    public DefaultTwillRunResources(int instanceId, String containerId, int cores, int memoryMB, int maxHeapMemoryMB, String host, Integer debugPort, Map<String, LogEntry.Level> logLevels) {
        this.instanceId = instanceId;
        this.containerId = containerId;
        this.virtualCores = cores;
        this.memoryMB = memoryMB;
        this.maxHeapMemoryMB = maxHeapMemoryMB;
        this.host = host;
        this.debugPort = debugPort;
        this.logLevels = new HashMap<String, LogEntry.Level>(logLevels);
    }

    @Override
    public int getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public int getVirtualCores() {
        return this.virtualCores;
    }

    @Override
    public int getMemoryMB() {
        return this.memoryMB;
    }

    @Override
    public int getMaxHeapMemoryMB() {
        return this.maxHeapMemoryMB;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public Integer getDebugPort() {
        return this.debugPort;
    }

    @Override
    @Deprecated
    @Nullable
    public LogEntry.Level getLogLevel() {
        return this.getLogLevels().get("ROOT");
    }

    @Override
    public Map<String, LogEntry.Level> getLogLevels() {
        return this.logLevels;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TwillRunResources)) {
            return false;
        }
        TwillRunResources other = (TwillRunResources)o;
        return this.instanceId == other.getInstanceId() && this.containerId.equals(other.getContainerId()) && this.host.equals(other.getHost()) && this.virtualCores == other.getVirtualCores() && this.memoryMB == other.getMemoryMB();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.containerId.hashCode();
        hash = 31 * hash + this.host.hashCode();
        hash = 31 * hash + (this.instanceId ^ this.instanceId >>> 32);
        hash = 31 * hash + (this.virtualCores ^ this.virtualCores >>> 32);
        hash = 31 * hash + (this.memoryMB ^ this.memoryMB >>> 32);
        return hash;
    }

    public String toString() {
        return "DefaultTwillRunResources{containerId='" + this.containerId + '\'' + ", instanceId=" + this.instanceId + ", virtualCores=" + this.virtualCores + ", memoryMB=" + this.memoryMB + ", host='" + this.host + '\'' + ", debugPort=" + this.debugPort + ", logLevels=" + this.logLevels + '}';
    }
}

