/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Objects;

public class Discoverable {
    private final String name;
    private final InetSocketAddress address;
    private final byte[] payload;

    public Discoverable(String name, InetSocketAddress address, byte[] payload) {
        this.name = name;
        this.address = address;
        this.payload = payload;
    }

    public Discoverable(String name, InetSocketAddress address) {
        this(name, address, new byte[0]);
    }

    public String getName() {
        return this.name;
    }

    public InetSocketAddress getSocketAddress() {
        return this.address;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String toString() {
        return "{name=" + this.name + ", address=" + this.address + ", payload=" + Arrays.toString(this.payload) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Discoverable other = (Discoverable)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.address, other.address) && Arrays.equals(this.payload, other.payload);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.address);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }
}

