/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.filesystem;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.FileContextLocationUtil;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;

final class FileContextLocation
implements Location {
    private final FileContextLocationFactory locationFactory;
    private final FileContext fc;
    private final Path path;

    FileContextLocation(FileContextLocationFactory locationFactory, FileContext fc, Path path) {
        this.locationFactory = locationFactory;
        this.fc = fc;
        this.path = path;
    }

    public boolean exists() throws IOException {
        return this.fc.util().exists(this.path);
    }

    public String getName() {
        return this.path.getName();
    }

    public boolean createNew() throws IOException {
        try {
            this.fc.create(this.path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()}).close();
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    public boolean createNew(String permission) throws IOException {
        try {
            FsPermission fsPermission = this.parsePermissions(permission);
            this.fc.create(this.path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent(), Options.CreateOpts.perms((FsPermission)fsPermission)}).close();
            this.fc.setPermission(this.path, fsPermission);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    public String getOwner() throws IOException {
        return this.fc.getFileStatus(this.path).getOwner();
    }

    public String getGroup() throws IOException {
        return this.fc.getFileStatus(this.path).getGroup();
    }

    public void setGroup(String group) throws IOException {
        this.fc.setOwner(this.path, null, group);
    }

    public String getPermissions() throws IOException {
        FsPermission permission = this.fc.getFileStatus(this.path).getPermission();
        return permission.getUserAction().SYMBOL + permission.getGroupAction().SYMBOL + permission.getOtherAction().SYMBOL;
    }

    public void setPermissions(String permission) throws IOException {
        this.fc.setPermission(this.path, this.parsePermissions(permission));
    }

    public InputStream getInputStream() throws IOException {
        return this.fc.open(this.path);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.fc.create(this.path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
    }

    public OutputStream getOutputStream(String permission) throws IOException {
        FsPermission fsPermission = this.parsePermissions(permission);
        FSDataOutputStream os = this.fc.create(this.path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)fsPermission), Options.CreateOpts.createParent()});
        this.fc.setPermission(this.path, fsPermission);
        return os;
    }

    public Location append(String child) throws IOException {
        if (child.startsWith("/")) {
            child = child.substring(1);
        }
        return new FileContextLocation(this.locationFactory, this.fc, new Path(URI.create(this.path.toUri() + "/" + child)));
    }

    public Location getTempFile(String suffix) throws IOException {
        Path path = new Path(URI.create(this.path.toUri() + "." + UUID.randomUUID() + (suffix == null ? ".tmp" : suffix)));
        return new FileContextLocation(this.locationFactory, this.fc, path);
    }

    public URI toURI() {
        URI uri = this.path.toUri();
        if (FileContextLocationUtil.useLogicalUri(this.locationFactory.getConfiguration(), uri)) {
            try {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return uri;
    }

    public boolean delete() throws IOException {
        return this.delete(false);
    }

    public boolean delete(boolean recursive) throws IOException {
        return this.fc.delete(this.path, recursive);
    }

    @Nullable
    public Location renameTo(Location destination) throws IOException {
        Path targetPath = new Path(destination.toURI());
        try {
            this.fc.rename(this.path, targetPath, new Options.Rename[]{Options.Rename.OVERWRITE});
            return new FileContextLocation(this.locationFactory, this.fc, targetPath);
        }
        catch (FileNotFoundException | FileAlreadyExistsException | ParentNotDirectoryException e) {
            return null;
        }
    }

    public boolean mkdirs() throws IOException {
        try {
            if (this.fc.util().exists(this.path)) {
                return false;
            }
            this.fc.mkdir(this.path, null, true);
            return true;
        }
        catch (FileAlreadyExistsException | AccessControlException e) {
            return false;
        }
    }

    public boolean mkdirs(String permission) throws IOException {
        return this.mkdirs(this.path, this.parsePermissions(permission));
    }

    private boolean mkdirs(Path path, FsPermission permission) throws IOException {
        try {
            if (this.fc.util().exists(path)) {
                return false;
            }
        }
        catch (AccessControlException e) {
            return false;
        }
        Path parent = path.getParent();
        if (null == parent) {
            return false;
        }
        if (this.fc.util().exists(parent)) {
            return this.mkdir(path, permission);
        }
        if (!this.mkdirs(parent, permission) && !this.isDirectory(parent)) {
            return false;
        }
        return this.mkdir(path, permission);
    }

    private boolean mkdir(Path path, FsPermission permission) throws IOException {
        block2: {
            try {
                this.fc.mkdir(path, null, true);
            }
            catch (FileAlreadyExistsException e) {
                if (this.isDirectory(path)) break block2;
                return false;
            }
        }
        this.fc.setPermission(path, permission);
        return true;
    }

    private boolean isDirectory(Path path) throws IOException {
        try {
            return this.fc.getFileStatus(path).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public long length() throws IOException {
        return this.fc.getFileStatus(this.path).getLen();
    }

    public long lastModified() throws IOException {
        return this.fc.getFileStatus(this.path).getModificationTime();
    }

    public boolean isDirectory() throws IOException {
        return this.isDirectory(this.path);
    }

    public List<Location> list() throws IOException {
        RemoteIterator statuses = this.fc.listStatus(this.path);
        ImmutableList.Builder result = ImmutableList.builder();
        while (statuses.hasNext()) {
            FileStatus status = (FileStatus)statuses.next();
            if (Objects.equals(this.path, status.getPath())) continue;
            result.add((Object)new FileContextLocation(this.locationFactory, this.fc, status.getPath()));
        }
        return result.build();
    }

    public LocationFactory getLocationFactory() {
        return this.locationFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileContextLocation that = (FileContextLocation)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return this.toURI().toString();
    }

    private FsPermission parsePermissions(String permission) {
        if (permission.length() == 3) {
            return new FsPermission(permission);
        }
        if (permission.length() == 9) {
            return FsPermission.valueOf((String)("-" + permission));
        }
        throw new IllegalArgumentException("Invalid permission " + permission + ". Permission should either be a three digit or nine character string.");
    }
}

