/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.filesystem;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;

final class FileContextLocationUtil {
    private static final MethodHandle HA_UTIL_USE_LOGICAL_URI_HANDLE;

    private static MethodHandle lookupInHAUtil(String className, String methodName) throws NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = FileContextLocationUtil.class.getClassLoader();
        }
        Class<?> utilClass = cl.loadClass(className);
        return MethodHandles.publicLookup().findStatic(utilClass, methodName, MethodType.methodType(Boolean.TYPE, new Class[]{Configuration.class, URI.class}));
    }

    static boolean useLogicalUri(Configuration configuration, URI uri) {
        try {
            if (HA_UTIL_USE_LOGICAL_URI_HANDLE == null) {
                return false;
            }
            return HA_UTIL_USE_LOGICAL_URI_HANDLE.invoke(configuration, uri);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private FileContextLocationUtil() {
    }

    static {
        MethodHandle handle;
        try {
            try {
                handle = FileContextLocationUtil.lookupInHAUtil("org.apache.hadoop.hdfs.HAUtil", "isLogicalUri");
            }
            catch (ClassNotFoundException | NoSuchMethodException ignored) {
                try {
                    handle = FileContextLocationUtil.lookupInHAUtil("org.apache.hadoop.hdfs.HAUtil", "useLogicalUri");
                }
                catch (ClassNotFoundException | NoSuchMethodException ignored1) {
                    try {
                        handle = FileContextLocationUtil.lookupInHAUtil("org.apache.hadoop.hdfs.HAUtilClient", "isLogicalUri");
                    }
                    catch (ClassNotFoundException | NoSuchMethodException ex) {
                        handle = null;
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            handle = null;
        }
        HA_UTIL_USE_LOGICAL_URI_HANDLE = handle;
    }
}

