/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.base.Objects;
import org.apache.hadoop.yarn.api.records.Resource;

public class AllocationSpecification {
    private Resource resource;
    private Type type;
    private String runnableName;
    private int instanceId;

    public AllocationSpecification(Resource resource) {
        this(resource, Type.DEFAULT, null, 0);
    }

    public AllocationSpecification(Resource resource, Type type, String runnableName, int instanceId) {
        this.resource = resource;
        this.type = type;
        this.runnableName = runnableName;
        this.instanceId = instanceId;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Type getType() {
        return this.type;
    }

    public String getRunnableName() {
        return this.runnableName;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocationSpecification)) {
            return false;
        }
        AllocationSpecification other = (AllocationSpecification)obj;
        return this.instanceId == other.instanceId && Objects.equal((Object)this.resource, (Object)other.resource) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.runnableName, (Object)other.runnableName);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    static enum Type {
        ALLOCATE_ONE_INSTANCE_AT_A_TIME,
        DEFAULT;

    }
}

