/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillSpecification;

final class ExpectedContainers {
    private final Map<String, ExpectedCount> expectedCounts;

    ExpectedContainers(TwillSpecification twillSpec) {
        HashMap expectedCounts = Maps.newHashMap();
        long now = System.currentTimeMillis();
        for (RuntimeSpecification runtimeSpec : twillSpec.getRunnables().values()) {
            expectedCounts.put(runtimeSpec.getName(), new ExpectedCount(runtimeSpec.getResourceSpecification().getInstances(), now));
        }
        this.expectedCounts = expectedCounts;
    }

    synchronized void setExpected(String runnable, int expected) {
        this.expectedCounts.put(runnable, new ExpectedCount(expected, System.currentTimeMillis()));
    }

    synchronized void updateRequestTime(Iterable<String> runnables) {
        for (String runnable : runnables) {
            ExpectedCount oldCount = this.expectedCounts.get(runnable);
            this.expectedCounts.put(runnable, new ExpectedCount(oldCount.getCount(), System.currentTimeMillis()));
        }
    }

    synchronized int getExpected(String runnable) {
        return this.expectedCounts.get(runnable).getCount();
    }

    synchronized Map<String, ExpectedCount> getAll() {
        return ImmutableMap.copyOf(this.expectedCounts);
    }

    static final class ExpectedCount {
        private final int count;
        private final long timestamp;

        private ExpectedCount(int count, long timestamp) {
            this.count = count;
            this.timestamp = timestamp;
        }

        int getCount() {
            return this.count;
        }

        long getTimestamp() {
            return this.timestamp;
        }
    }
}

