/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.internal.appmaster.AllocationSpecification;

final class ProvisionRequest {
    private final RuntimeSpecification runtimeSpec;
    private final String requestId;
    private int requestCount;
    private final AllocationSpecification.Type type;

    ProvisionRequest(RuntimeSpecification runtimeSpec, String requestId, int requestCount) {
        this(runtimeSpec, requestId, requestCount, AllocationSpecification.Type.DEFAULT);
    }

    ProvisionRequest(RuntimeSpecification runtimeSpec, String requestId, int requestCount, AllocationSpecification.Type type) {
        this.runtimeSpec = runtimeSpec;
        this.requestId = requestId;
        this.requestCount = requestCount;
        this.type = type;
    }

    RuntimeSpecification getRuntimeSpec() {
        return this.runtimeSpec;
    }

    String getRequestId() {
        return this.requestId;
    }

    boolean containerAcquired() {
        --this.requestCount;
        return this.requestCount == 0;
    }

    AllocationSpecification.Type getType() {
        return this.type;
    }
}

