/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.internal.appmaster.AllocationSpecification;

final class RunnableContainerRequest {
    private final TwillSpecification.Order.Type orderType;
    private final Iterator<Map.Entry<AllocationSpecification, Collection<RuntimeSpecification>>> requests;
    private volatile boolean isReadyToBeProvisioned;

    RunnableContainerRequest(TwillSpecification.Order.Type orderType, Map<AllocationSpecification, Collection<RuntimeSpecification>> requests) {
        this(orderType, requests, true);
    }

    RunnableContainerRequest(TwillSpecification.Order.Type orderType, Map<AllocationSpecification, Collection<RuntimeSpecification>> requests, boolean isReadyToBeProvisioned) {
        this.orderType = orderType;
        this.requests = requests.entrySet().iterator();
        this.isReadyToBeProvisioned = isReadyToBeProvisioned;
    }

    TwillSpecification.Order.Type getOrderType() {
        return this.orderType;
    }

    boolean isReadyToBeProvisioned() {
        return this.isReadyToBeProvisioned;
    }

    void setReadyToBeProvisioned() {
        this.isReadyToBeProvisioned = true;
    }

    Map.Entry<AllocationSpecification, ? extends Collection<RuntimeSpecification>> takeRequest() {
        Map.Entry next = (Map.Entry)Iterators.getNext(this.requests, null);
        return next == null ? null : Maps.immutableEntry(next.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)next.getValue())));
    }
}

