/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.twill.api.ResourceReport;
import org.apache.twill.internal.json.ResourceReportAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrackerService
extends AbstractIdleService {
    public static final String PATH = "/resources";
    private static final Logger LOG = LoggerFactory.getLogger(TrackerService.class);
    private static final int NUM_BOSS_THREADS = 1;
    private static final int NUM_WORKER_THREADS = 10;
    private static final int CLOSE_CHANNEL_TIMEOUT = 5;
    private static final int MAX_INPUT_SIZE = 0x6400000;
    private final Supplier<ResourceReport> resourceReport;
    private String host;
    private ServerBootstrap bootstrap;
    private ChannelGroup channelGroup;
    private InetSocketAddress bindAddress;
    private URL url;

    TrackerService(Supplier<ResourceReport> resourceReport) {
        this.resourceReport = resourceReport;
    }

    void setHost(String host) {
        this.host = host;
    }

    InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    URL getUrl() {
        return this.url;
    }

    protected void startUp() throws Exception {
        this.channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("boss-thread").build());
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("worker-thread#%d").build());
        this.bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                TrackerService.this.channelGroup.add((Object)ch);
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec());
                pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
                pipeline.addLast("handler", (ChannelHandler)new ReportHandler());
            }
        });
        Channel serverChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.host, 0)).sync().channel();
        this.channelGroup.add((Object)serverChannel);
        this.bindAddress = (InetSocketAddress)serverChannel.localAddress();
        this.url = URI.create(String.format("http://%s:%d", this.host, this.bindAddress.getPort())).toURL();
        LOG.info("Tracker service started at {}", (Object)this.url);
    }

    protected void shutDown() throws Exception {
        this.channelGroup.close().awaitUninterruptibly();
        ArrayList<Future> futures = new ArrayList<Future>();
        futures.add(this.bootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS));
        futures.add(this.bootstrap.config().childGroup().shutdownGracefully(0L, 5L, TimeUnit.SECONDS));
        for (Future future : futures) {
            future.awaitUninterruptibly();
        }
        LOG.info("Tracker service stopped at {}", (Object)this.url);
    }

    final class ReportHandler
    extends ChannelInboundHandlerAdapter {
        private final ResourceReportAdapter reportAdapter = ResourceReportAdapter.create();

        ReportHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (!(msg instanceof HttpRequest)) {
                    return;
                }
                HttpRequest request = (HttpRequest)msg;
                if (!HttpMethod.GET.equals((Object)request.method())) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED, Unpooled.copiedBuffer((CharSequence)"Only GET is supported", (Charset)StandardCharsets.UTF_8));
                    HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
                    response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
                    this.writeAndClose(ctx.channel(), (HttpResponse)response);
                    return;
                }
                if (!TrackerService.PATH.equals(request.uri())) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TEMPORARY_REDIRECT);
                    HttpUtil.setContentLength((HttpMessage)response, (long)0L);
                    response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)TrackerService.PATH);
                    this.writeAndClose(ctx.channel(), (HttpResponse)response);
                    return;
                }
                this.writeResourceReport(ctx.channel());
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.channel().close();
        }

        private void writeResourceReport(Channel channel) {
            ByteBuf content = Unpooled.buffer();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream(content), CharsetUtil.UTF_8);
            try {
                this.reportAdapter.toJson((ResourceReport)TrackerService.this.resourceReport.get(), (Writer)writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                LOG.error("error writing resource report", (Throwable)e);
                this.writeAndClose(channel, (HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((CharSequence)e.getMessage(), (Charset)StandardCharsets.UTF_8)));
                return;
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
            HttpUtil.setContentLength((HttpMessage)response, (long)content.readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
            channel.writeAndFlush((Object)response);
        }

        private void writeAndClose(Channel channel, HttpResponse response) {
            channel.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

