/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.container;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Service;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.twill.api.RunId;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ZKDiscoveryService;
import org.apache.twill.internal.Arguments;
import org.apache.twill.internal.BasicTwillContext;
import org.apache.twill.internal.ContainerInfo;
import org.apache.twill.internal.EnvContainerInfo;
import org.apache.twill.internal.RunIds;
import org.apache.twill.internal.ServiceMain;
import org.apache.twill.internal.TwillRuntimeSpecification;
import org.apache.twill.internal.container.TwillContainerService;
import org.apache.twill.internal.json.ArgumentsCodec;
import org.apache.twill.internal.json.TwillRuntimeSpecificationAdapter;
import org.apache.twill.internal.logging.Loggings;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwillContainerMain
extends ServiceMain {
    private static final Logger LOG = LoggerFactory.getLogger(TwillContainerMain.class);
    private final TwillRuntimeSpecification twillRuntimeSpec;

    public static void main(String[] args) throws Exception {
        File twillSpecFile = new File("runtime.config.jar", "twillSpec.json");
        TwillRuntimeSpecification twillRuntimeSpec = TwillRuntimeSpecificationAdapter.create().fromJson(twillSpecFile);
        new TwillContainerMain(twillRuntimeSpec).doMain();
    }

    private TwillContainerMain(TwillRuntimeSpecification twillRuntimeSpec) {
        this.twillRuntimeSpec = twillRuntimeSpec;
    }

    private void doMain() throws Exception {
        TwillContainerMain.loadSecureStore();
        RunId appRunId = this.twillRuntimeSpec.getTwillAppRunId();
        RunId runId = RunIds.fromString((String)System.getenv("TWILL_RUN_ID"));
        String runnableName = System.getenv("TWILL_RUNNABLE_NAME");
        int instanceId = Integer.valueOf(System.getenv("TWILL_INSTANCE_ID"));
        int instanceCount = Integer.valueOf(System.getenv("TWILL_INSTANCE_COUNT"));
        Map defaultLogLevels = (Map)this.twillRuntimeSpec.getLogLevels().get(runnableName);
        Map<String, String> dynamicLogLevels = TwillContainerMain.loadLogLevels().get(runnableName);
        HashMap<String, String> logLevels = new HashMap<String, String>();
        if (defaultLogLevels != null) {
            logLevels.putAll(defaultLogLevels);
        } else {
            defaultLogLevels = ImmutableMap.of();
        }
        if (dynamicLogLevels != null) {
            logLevels.putAll(dynamicLogLevels);
        }
        ZKClientService zkClientService = this.createZKClient();
        ZKDiscoveryService discoveryService = new ZKDiscoveryService((ZKClient)zkClientService);
        ZKClient appRunZkClient = TwillContainerMain.getAppRunZKClient((ZKClient)zkClientService, appRunId);
        TwillRunnableSpecification runnableSpec = ((RuntimeSpecification)this.twillRuntimeSpec.getTwillSpecification().getRunnables().get(runnableName)).getRunnableSpecification();
        EnvContainerInfo containerInfo = new EnvContainerInfo();
        Arguments arguments = TwillContainerMain.decodeArgs();
        BasicTwillContext context = new BasicTwillContext(runId, appRunId, containerInfo.getHost(), arguments.getRunnableArguments().get((Object)runnableName).toArray(new String[0]), arguments.getArguments().toArray(new String[0]), runnableSpec, instanceId, (DiscoveryService)discoveryService, (DiscoveryServiceClient)discoveryService, appRunZkClient, instanceCount, containerInfo.getMemoryMB(), containerInfo.getVirtualCores());
        ZKClient containerZKClient = TwillContainerMain.getContainerZKClient((ZKClient)zkClientService, appRunId, runnableName);
        YarnConfiguration conf = new YarnConfiguration((Configuration)new HdfsConfiguration(new Configuration()));
        TwillContainerService service = new TwillContainerService(context, (ContainerInfo)containerInfo, containerZKClient, runId, runnableSpec, TwillContainerMain.getClassLoader(), (Configuration)conf, this.createAppLocation((Configuration)conf, this.twillRuntimeSpec.getFsUser(), this.twillRuntimeSpec.getTwillAppDir()), defaultLogLevels, logLevels);
        this.doMain((Service)service, new Service[]{zkClientService, new LogFlushService(), new ServiceMain.TwillZKPathService(containerZKClient, runId), new CloseableServiceWrapper((AutoCloseable)discoveryService)});
    }

    private static void loadSecureStore() throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        File file = new File("credentials.store");
        if (file.exists()) {
            Credentials credentials = new Credentials();
            try (DataInputStream input = new DataInputStream(new FileInputStream(file));){
                credentials.readTokenStorageStream(input);
            }
            UserGroupInformation.getCurrentUser().addCredentials(credentials);
            LOG.info("Secure store updated from {}", (Object)file);
        }
    }

    private static ZKClient getAppRunZKClient(ZKClient zkClient, RunId appRunId) {
        return ZKClients.namespace((ZKClient)zkClient, (String)String.format("/%s", appRunId));
    }

    private static ZKClient getContainerZKClient(ZKClient zkClient, RunId appRunId, String runnableName) {
        return ZKClients.namespace((ZKClient)zkClient, (String)String.format("/%s/runnables/%s", appRunId, runnableName));
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static Map<String, Map<String, String>> loadLogLevels() throws IOException {
        File file = new File("logLevel.json");
        if (file.exists()) {
            try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
                Gson gson = new GsonBuilder().serializeNulls().create();
                Map map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, String>>>(){}.getType());
                return map;
            }
        }
        return new HashMap<String, Map<String, String>>();
    }

    private static Arguments decodeArgs() throws IOException {
        return ArgumentsCodec.decode((InputSupplier)Files.newReaderSupplier((File)new File("runtime.config.jar", "arguments.json"), (Charset)Charsets.UTF_8));
    }

    @Override
    protected String getHostname() {
        return System.getenv("YARN_CONTAINER_HOST");
    }

    @Override
    protected TwillRuntimeSpecification getTwillRuntimeSpecification() {
        return this.twillRuntimeSpec;
    }

    @Override
    protected String getRunnableName() {
        return System.getenv("TWILL_RUNNABLE_NAME");
    }

    private static final class CloseableServiceWrapper
    extends AbstractIdleService {
        private final AutoCloseable closeable;

        private CloseableServiceWrapper(AutoCloseable closeable) {
            this.closeable = closeable;
        }

        protected void startUp() throws Exception {
        }

        protected void shutDown() throws Exception {
            this.closeable.close();
        }
    }

    private static final class LogFlushService
    extends AbstractService {
        private LogFlushService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            Loggings.forceFlush();
            this.notifyStopped();
        }
    }
}

