/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.container;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.api.Command;
import org.apache.twill.api.RunId;
import org.apache.twill.api.TwillContext;
import org.apache.twill.api.TwillRunnable;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.api.logging.LogEntry;
import org.apache.twill.common.Threads;
import org.apache.twill.filesystem.Location;
import org.apache.twill.internal.BasicTwillContext;
import org.apache.twill.internal.ContainerInfo;
import org.apache.twill.internal.ContainerLiveNodeData;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.utils.Instances;
import org.apache.twill.internal.yarn.AbstractYarnTwillService;
import org.apache.twill.zookeeper.ZKClient;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwillContainerService
extends AbstractYarnTwillService {
    private static final Logger LOG = LoggerFactory.getLogger(TwillContainerService.class);
    private final TwillRunnableSpecification specification;
    private final ClassLoader classLoader;
    private final BasicTwillContext context;
    private final ContainerLiveNodeData containerLiveNodeData;
    private final Map<String, String> oldLogLevels;
    private final Map<String, String> defaultLogLevels;
    private ExecutorService commandExecutor;
    private TwillRunnable runnable;

    TwillContainerService(BasicTwillContext context, ContainerInfo containerInfo, ZKClient zkClient, RunId runId, TwillRunnableSpecification specification, ClassLoader classLoader, Configuration config, Location applicationLocation, Map<String, String> defaultLogLevels, Map<String, String> logLevels) {
        super(zkClient, runId, config, applicationLocation);
        this.specification = specification;
        this.classLoader = classLoader;
        this.defaultLogLevels = ImmutableMap.copyOf(defaultLogLevels);
        this.oldLogLevels = new HashMap<String, String>(defaultLogLevels);
        this.containerLiveNodeData = this.createLiveNodeData(containerInfo, this.isLoggerContext() ? logLevels : Collections.emptyMap());
        this.context = context;
    }

    private ContainerLiveNodeData createLiveNodeData(ContainerInfo containerInfo, Map<String, String> logLevels) {
        String debugPort = System.getProperty("twill.debug.port");
        if (debugPort != null) {
            LOG.info("JVM is listening for debugger on port {}", (Object)debugPort);
        }
        return new ContainerLiveNodeData(containerInfo.getId(), containerInfo.getHost().getCanonicalHostName(), debugPort, logLevels);
    }

    protected Object getLiveNodeData() {
        return this.containerLiveNodeData;
    }

    public ListenableFuture<String> onReceived(final String messageId, final Message message) {
        LOG.debug("Message received: {} {}.", (Object)messageId, (Object)message);
        if (this.handleSecureStoreUpdate(message)) {
            return Futures.immediateFuture((Object)messageId);
        }
        final SettableFuture result = SettableFuture.create();
        Command command = message.getCommand();
        if (message.getType() == Message.Type.SYSTEM && "instances".equals(command.getCommand()) && command.getOptions().containsKey("count")) {
            this.context.setInstanceCount(Integer.parseInt((String)command.getOptions().get("count")));
        }
        String commandStr = command.getCommand();
        if (message.getType() == Message.Type.SYSTEM) {
            boolean handled = false;
            if ("setLogLevels".equals(commandStr)) {
                this.setLogLevels(command.getOptions());
                handled = true;
            } else if ("resetLogLevels".equals(commandStr)) {
                this.resetLogLevels(command.getOptions().keySet());
                handled = true;
            }
            if (handled) {
                this.updateLiveNode();
                return Futures.immediateFuture((Object)messageId);
            }
        }
        this.commandExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TwillContainerService.this.runnable.handleCommand(message.getCommand());
                    result.set((Object)messageId);
                }
                catch (Exception e) {
                    result.setException((Throwable)e);
                }
            }
        });
        return result;
    }

    private void setLogLevels(Map<String, String> logLevels) {
        for (Map.Entry<String, String> entry : logLevels.entrySet()) {
            String loggerName = entry.getKey();
            String logLevel = entry.getValue();
            String oldLogLevel = this.setLogLevel(loggerName, logLevel);
            this.containerLiveNodeData.setLogLevel(loggerName, logLevel);
            if (this.oldLogLevels.containsKey(loggerName)) continue;
            String defaultLogLevel = this.defaultLogLevels.get(loggerName);
            this.oldLogLevels.put(loggerName, defaultLogLevel == null ? oldLogLevel : defaultLogLevel);
        }
    }

    private void resetLogLevels(Set<String> loggerNames) {
        Iterator<Map.Entry<String, String>> entryIterator = this.oldLogLevels.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> entry = entryIterator.next();
            String loggerName = entry.getKey();
            if (!loggerNames.isEmpty() && !loggerNames.contains(loggerName)) continue;
            String oldLogLevel = entry.getValue();
            this.setLogLevel(loggerName, oldLogLevel);
            if (oldLogLevel == null || !this.defaultLogLevels.containsKey(loggerName)) {
                this.containerLiveNodeData.removeLogLevel(loggerName);
                entryIterator.remove();
                continue;
            }
            this.containerLiveNodeData.setLogLevel(loggerName, oldLogLevel);
        }
    }

    protected void doStart() throws Exception {
        for (Map.Entry entry : this.containerLiveNodeData.getLogLevels().entrySet()) {
            String loggerName = (String)entry.getKey();
            String oldLogLevel = this.setLogLevel(loggerName, (String)entry.getValue());
            if (this.defaultLogLevels.containsKey(loggerName)) continue;
            this.oldLogLevels.put(loggerName, oldLogLevel);
        }
        this.commandExecutor = Executors.newSingleThreadExecutor(Threads.createDaemonThreadFactory((String)"runnable-command-executor"));
        Class<?> runnableClass = this.classLoader.loadClass(this.specification.getClassName());
        Preconditions.checkArgument((boolean)TwillRunnable.class.isAssignableFrom(runnableClass), (String)"Class %s is not instance of TwillRunnable.", (Object[])new Object[]{this.specification.getClassName()});
        this.runnable = (TwillRunnable)Instances.newInstance(runnableClass);
        this.runnable.initialize((TwillContext)this.context);
    }

    protected void doRun() throws Exception {
        this.runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(long terminationTimeoutMillis) throws Exception {
        this.commandExecutor.shutdownNow();
        try {
            this.runnable.destroy();
        }
        catch (Throwable t) {
            LOG.warn("Exception when calling runnable.destroy.", t);
        }
        finally {
            this.context.stop();
        }
    }

    protected void triggerShutdown() {
        try {
            this.context.setTerminationTimeoutMillis(this.getTerminationTimeoutMillis(60L, TimeUnit.SECONDS));
            this.runnable.stop();
        }
        catch (Throwable t) {
            LOG.error("Exception when stopping runnable.", t);
        }
    }

    private boolean isLoggerContext() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        return loggerFactory instanceof LoggerContext;
    }

    @Nullable
    private String setLogLevel(String loggerName, @Nullable String logLevel) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            LOG.error("LoggerFactory is not a logback LoggerContext, cannot make the log level change");
            return null;
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactory;
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger(loggerName);
        LogEntry.Level oldLogLevel = logger.getLevel() == null ? null : LogEntry.Level.valueOf((String)logger.getLevel().toString());
        LOG.debug("Log level of {} changed from {} to {}", new Object[]{loggerName, oldLogLevel, logLevel});
        logger.setLevel(logLevel == null ? null : Level.toLevel((String)logLevel, (Level)Level.ERROR));
        return oldLogLevel == null ? null : oldLogLevel.name();
    }
}

