/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractIdleService;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.appmaster.RunnableProcessLauncher;
import org.apache.twill.internal.yarn.YarnAMClient;
import org.apache.twill.internal.yarn.YarnContainerInfo;
import org.apache.twill.internal.yarn.YarnContainerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYarnAMClient<T>
extends AbstractIdleService
implements YarnAMClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractYarnAMClient.class);
    private final Multimap<String, T> inflightRequests;
    private final Multimap<String, T> pendingRequests;
    private final List<T> pendingRemoves;
    private final List<String> blacklistAdditions;
    private final List<String> blacklistRemovals;
    private final List<String> blacklistedResources;
    protected final Set<String> unsupportedFeatures = Sets.newHashSet();
    protected final ContainerId containerId;
    protected InetSocketAddress trackerAddr;
    protected URL trackerUrl;

    protected AbstractYarnAMClient(String containerIdEnvName) {
        String masterContainerId = System.getenv().get(containerIdEnvName);
        Preconditions.checkArgument((masterContainerId != null ? 1 : 0) != 0, (String)"Missing %s from environment", (Object[])new Object[]{containerIdEnvName});
        this.containerId = this.containerIdLookup(masterContainerId);
        this.inflightRequests = ArrayListMultimap.create();
        this.pendingRequests = ArrayListMultimap.create();
        this.pendingRemoves = Lists.newLinkedList();
        this.blacklistAdditions = Lists.newArrayList();
        this.blacklistRemovals = Lists.newArrayList();
        this.blacklistedResources = Lists.newArrayList();
    }

    @Override
    public final ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public final void setTracker(InetSocketAddress trackerAddr, URL trackerUrl) {
        this.trackerAddr = trackerAddr;
        this.trackerUrl = trackerUrl;
    }

    @Override
    public final synchronized void allocate(float progress, YarnAMClient.AllocateHandler handler) throws Exception {
        List<YarnContainerStatus> completed;
        AllocateResult allocateResponse;
        List<RunnableProcessLauncher> launchers;
        if (this.pendingRemoves.isEmpty()) {
            for (Map.Entry entry : this.pendingRequests.entries()) {
                this.addContainerRequest(entry.getValue());
            }
            this.inflightRequests.putAll(this.pendingRequests);
            this.pendingRequests.clear();
        } else {
            for (Object request : this.pendingRemoves) {
                this.removeContainerRequest(request);
            }
            this.pendingRemoves.clear();
        }
        if (!this.blacklistAdditions.isEmpty() || !this.blacklistRemovals.isEmpty()) {
            this.updateBlacklist(this.blacklistAdditions, this.blacklistRemovals);
            this.blacklistAdditions.clear();
            this.blacklistRemovals.clear();
        }
        if (!(launchers = (allocateResponse = this.doAllocate(progress)).getLaunchers()).isEmpty()) {
            if (!this.inflightRequests.isEmpty()) {
                handler.acquired(launchers);
            }
            for (ProcessLauncher processLauncher : launchers) {
                RunnableProcessLauncher launcher = (RunnableProcessLauncher)processLauncher;
                if (launcher.isLaunched()) continue;
                YarnContainerInfo containerInfo = (YarnContainerInfo)launcher.getContainerInfo();
                LOG.info("Nothing to run in container, releasing it: {}", containerInfo.getContainer());
                this.releaseAssignedContainer(containerInfo);
            }
        }
        if (!(completed = allocateResponse.getCompletedStatus()).isEmpty()) {
            handler.completed(completed);
        }
    }

    @Override
    public final YarnAMClient.ContainerRequestBuilder addContainerRequest(Resource capability, int count) {
        return new YarnAMClient.ContainerRequestBuilder(this.adjustCapability(capability), count){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String apply() {
                AbstractYarnAMClient abstractYarnAMClient = AbstractYarnAMClient.this;
                synchronized (abstractYarnAMClient) {
                    String id = UUID.randomUUID().toString();
                    String[] hosts = this.hosts.isEmpty() ? null : this.hosts.toArray(new String[this.hosts.size()]);
                    String[] racks = this.racks.isEmpty() ? null : this.racks.toArray(new String[this.racks.size()]);
                    for (int i = 0; i < this.count; ++i) {
                        Object request = AbstractYarnAMClient.this.createContainerRequest(this.priority, this.capability, hosts, racks, this.relaxLocality);
                        AbstractYarnAMClient.this.pendingRequests.put((Object)id, request);
                    }
                    return id;
                }
            }
        };
    }

    @Override
    public final void addToBlacklist(String resource) {
        if (!this.blacklistAdditions.contains(resource) && !this.blacklistedResources.contains(resource)) {
            this.blacklistAdditions.add(resource);
            this.blacklistedResources.add(resource);
            this.blacklistRemovals.remove(resource);
        }
    }

    @Override
    public final void removeFromBlacklist(String resource) {
        if (!this.blacklistRemovals.contains(resource) && this.blacklistedResources.contains(resource)) {
            this.blacklistRemovals.add(resource);
            this.blacklistedResources.remove(resource);
            this.blacklistAdditions.remove(resource);
        }
    }

    @Override
    public final void clearBlacklist() {
        this.blacklistRemovals.addAll(this.blacklistedResources);
        this.blacklistedResources.clear();
        this.blacklistAdditions.clear();
    }

    @Override
    public final synchronized void completeContainerRequest(String id) {
        for (Object request : this.inflightRequests.removeAll((Object)id)) {
            this.pendingRemoves.add(request);
        }
    }

    protected boolean recordUnsupportedFeature(String unsupportedFeature) {
        if (this.unsupportedFeatures.contains(unsupportedFeature)) {
            return false;
        }
        this.unsupportedFeatures.add(unsupportedFeature);
        return true;
    }

    protected abstract ContainerId containerIdLookup(String var1);

    protected abstract Resource adjustCapability(Resource var1);

    protected abstract T createContainerRequest(Priority var1, Resource var2, @Nullable String[] var3, @Nullable String[] var4, boolean var5);

    protected abstract void addContainerRequest(T var1);

    protected abstract void removeContainerRequest(T var1);

    protected abstract void updateBlacklist(List<String> var1, List<String> var2);

    protected abstract AllocateResult doAllocate(float var1) throws Exception;

    protected abstract void releaseAssignedContainer(YarnContainerInfo var1);

    protected static final class AllocateResult {
        private final List<RunnableProcessLauncher> launchers;
        private final List<YarnContainerStatus> completedStatus;

        public AllocateResult(List<RunnableProcessLauncher> launchers, List<YarnContainerStatus> completedStatus) {
            this.launchers = ImmutableList.copyOf(launchers);
            this.completedStatus = ImmutableList.copyOf(completedStatus);
        }

        public List<RunnableProcessLauncher> getLaunchers() {
            return this.launchers;
        }

        public List<YarnContainerStatus> getCompletedStatus() {
            return this.completedStatus;
        }
    }
}

