/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.twill.api.LocalFile;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.ResourceCapability;
import org.apache.twill.internal.yarn.YarnLaunchContext;
import org.apache.twill.internal.yarn.YarnLocalResource;
import org.apache.twill.internal.yarn.YarnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYarnProcessLauncher<T extends ResourceCapability>
implements ProcessLauncher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractYarnProcessLauncher.class);
    private final T containerInfo;

    protected AbstractYarnProcessLauncher(T containerInfo) {
        this.containerInfo = containerInfo;
    }

    public T getContainerInfo() {
        return this.containerInfo;
    }

    public <C> ProcessLauncher.PrepareLaunchContext prepareLaunch(Map<String, String> environments, Iterable<LocalFile> resources, C credentials) {
        if (credentials != null) {
            Preconditions.checkArgument((boolean)(credentials instanceof Credentials), (String)"Credentials should be of type %s", (Object[])new Object[]{Credentials.class.getName()});
        }
        return new PrepareLaunchContextImpl(environments, resources, (Credentials)credentials);
    }

    protected abstract <R> ProcessController<R> doLaunch(YarnLaunchContext var1);

    private final class PrepareLaunchContextImpl
    implements ProcessLauncher.PrepareLaunchContext {
        private final Credentials credentials;
        private final YarnLaunchContext launchContext;
        private final Map<String, YarnLocalResource> localResources;
        private final Map<String, String> environment;
        private final List<String> commands;

        private PrepareLaunchContextImpl(Map<String, String> env, Iterable<LocalFile> localFiles, Credentials credentials) {
            this.credentials = credentials;
            this.launchContext = YarnUtils.createLaunchContext();
            this.localResources = Maps.newHashMap();
            this.environment = Maps.newHashMap(env);
            this.commands = Lists.newLinkedList();
            for (LocalFile localFile : localFiles) {
                this.addLocalFile(localFile);
            }
        }

        private void addLocalFile(LocalFile localFile) {
            this.localResources.put(localFile.getName(), YarnUtils.createLocalResource(localFile));
        }

        public ProcessLauncher.PrepareLaunchContext addResources(LocalFile ... localFiles) {
            return this.addResources(Arrays.asList(localFiles));
        }

        public ProcessLauncher.PrepareLaunchContext addResources(Iterable<LocalFile> localFiles) {
            for (LocalFile localFile : localFiles) {
                this.addLocalFile(localFile);
            }
            return this;
        }

        public <V> ProcessLauncher.PrepareLaunchContext addEnvironment(String key, V value) {
            this.environment.put(key, value.toString());
            return this;
        }

        public ProcessLauncher.PrepareLaunchContext addCommand(String cmd, String ... args) {
            StringBuilder builder = new StringBuilder(cmd);
            for (String arg : args) {
                builder.append(' ').append(arg);
            }
            this.redirect(1, "stdout", builder);
            this.redirect(2, "stderr", builder);
            this.commands.add(builder.toString());
            return this;
        }

        public <R> ProcessController<R> launch() {
            this.launchContext.setLocalResources(this.localResources);
            this.launchContext.setEnvironment(this.environment);
            if (this.credentials != null && !this.credentials.getAllTokens().isEmpty()) {
                for (Token token : this.credentials.getAllTokens()) {
                    LOG.info("Launch with delegation token {}", (Object)token);
                }
                this.launchContext.setCredentials(this.credentials);
            }
            this.launchContext.setCommands(this.commands);
            return AbstractYarnProcessLauncher.this.doLaunch(this.launchContext);
        }

        private void redirect(int type, String out, StringBuilder commandBuilder) {
            commandBuilder.append(' ').append(type).append('>').append("<LOG_DIR>").append('/').append(out);
        }
    }
}

