/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.twill.api.RunId;
import org.apache.twill.filesystem.Location;
import org.apache.twill.internal.AbstractTwillService;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.state.SystemMessages;
import org.apache.twill.internal.yarn.YarnUtils;
import org.apache.twill.zookeeper.ZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractYarnTwillService
extends AbstractTwillService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractYarnTwillService.class);
    private final Configuration config;
    private final Location applicationLocation;
    protected volatile Credentials credentials;

    protected AbstractYarnTwillService(ZKClient zkClient, RunId runId, Configuration config, Location applicationLocation) {
        super(zkClient, runId);
        this.config = config;
        this.applicationLocation = applicationLocation;
    }

    protected final Location getSecureStoreLocation() {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return null;
        }
        try {
            return this.applicationLocation.append("credentials.store");
        }
        catch (IOException e) {
            LOG.error("Failed to create secure store location.", (Throwable)e);
            return null;
        }
    }

    protected final boolean handleSecureStoreUpdate(Message message) {
        if (!SystemMessages.SECURE_STORE_UPDATED.equals(message)) {
            return false;
        }
        if (!UserGroupInformation.isSecurityEnabled()) {
            return true;
        }
        try {
            Credentials credentials = new Credentials();
            Location location = this.getSecureStoreLocation();
            if (location == null) {
                return true;
            }
            try (DataInputStream input = new DataInputStream(new BufferedInputStream(location.getInputStream()));){
                credentials.readTokenStorageStream(input);
            }
            UserGroupInformation.getCurrentUser().addCredentials(credentials);
            YarnUtils.cloneHaNnCredentials(this.config);
            this.credentials = credentials;
            LOG.info("Secure store updated from {}.", (Object)location);
        }
        catch (Throwable t) {
            LOG.error("Failed to update secure store.", t);
        }
        return true;
    }
}

