/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.twill.internal.appmaster.RunnableProcessLauncher;
import org.apache.twill.internal.yarn.AbstractYarnAMClient;
import org.apache.twill.internal.yarn.Hadoop21YarnContainerInfo;
import org.apache.twill.internal.yarn.Hadoop21YarnContainerStatus;
import org.apache.twill.internal.yarn.Hadoop21YarnNMClient;
import org.apache.twill.internal.yarn.YarnContainerInfo;
import org.apache.twill.internal.yarn.YarnContainerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop21YarnAMClient
extends AbstractYarnAMClient<AMRMClient.ContainerRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop21YarnAMClient.class);
    protected static final Function<ContainerStatus, YarnContainerStatus> STATUS_TRANSFORM = new Function<ContainerStatus, YarnContainerStatus>(){

        public YarnContainerStatus apply(ContainerStatus status) {
            return new Hadoop21YarnContainerStatus(status);
        }
    };
    protected final AMRMClient<AMRMClient.ContainerRequest> amrmClient = AMRMClient.createAMRMClient();
    protected final Hadoop21YarnNMClient nmClient;
    protected Resource maxCapability;

    @Override
    protected ContainerId containerIdLookup(String containerIdStr) {
        return ConverterUtils.toContainerId((String)containerIdStr);
    }

    public Hadoop21YarnAMClient(Configuration conf) {
        super(ApplicationConstants.Environment.CONTAINER_ID.name());
        this.amrmClient.init(conf);
        this.nmClient = new Hadoop21YarnNMClient(conf);
    }

    protected void startUp() throws Exception {
        Preconditions.checkNotNull((Object)this.trackerAddr, (Object)"Tracker address not set.");
        Preconditions.checkNotNull((Object)this.trackerUrl, (Object)"Tracker URL not set.");
        this.amrmClient.start();
        RegisterApplicationMasterResponse response = this.amrmClient.registerApplicationMaster(this.trackerAddr.getHostName(), this.trackerAddr.getPort(), this.trackerUrl.toString());
        this.maxCapability = response.getMaximumResourceCapability();
        this.nmClient.startAndWait();
    }

    protected void shutDown() throws Exception {
        this.nmClient.stopAndWait();
        this.amrmClient.unregisterApplicationMaster(FinalApplicationStatus.SUCCEEDED, null, this.trackerUrl.toString());
        this.amrmClient.stop();
    }

    @Override
    public String getHost() {
        return System.getenv().get(ApplicationConstants.Environment.NM_HOST.name());
    }

    @Override
    public int getNMPort() {
        return Integer.parseInt(System.getenv().get(ApplicationConstants.Environment.NM_PORT.name()));
    }

    @Override
    protected AMRMClient.ContainerRequest createContainerRequest(Priority priority, Resource capability, @Nullable String[] hosts, @Nullable String[] racks, boolean relaxLocality) {
        return new AMRMClient.ContainerRequest(capability, hosts, racks, priority, relaxLocality);
    }

    @Override
    protected void addContainerRequest(AMRMClient.ContainerRequest request) {
        this.amrmClient.addContainerRequest(request);
    }

    @Override
    protected void removeContainerRequest(AMRMClient.ContainerRequest request) {
        this.amrmClient.removeContainerRequest(request);
    }

    @Override
    protected void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (this.recordUnsupportedFeature("blacklist")) {
            LOG.warn("Blacklist is not supported in Hadoop 2.1 AMRMClient");
        }
    }

    @Override
    protected AbstractYarnAMClient.AllocateResult doAllocate(float progress) throws Exception {
        AllocateResponse allocateResponse = this.amrmClient.allocate(progress);
        ArrayList launchers = Lists.newArrayListWithCapacity((int)allocateResponse.getAllocatedContainers().size());
        for (Container container : allocateResponse.getAllocatedContainers()) {
            launchers.add(new RunnableProcessLauncher(new Hadoop21YarnContainerInfo(container), this.nmClient));
        }
        ImmutableList completed = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)allocateResponse.getCompletedContainersStatuses(), STATUS_TRANSFORM));
        return new AbstractYarnAMClient.AllocateResult(launchers, (List<YarnContainerStatus>)completed);
    }

    @Override
    protected void releaseAssignedContainer(YarnContainerInfo containerInfo) {
        Container container = (Container)containerInfo.getContainer();
        this.amrmClient.releaseAssignedContainer(container.getId());
    }

    @Override
    protected Resource adjustCapability(Resource resource) {
        int updatedCores;
        int cores = resource.getVirtualCores();
        if (cores != (updatedCores = Math.min(resource.getVirtualCores(), this.maxCapability.getVirtualCores()))) {
            resource.setVirtualCores(updatedCores);
            LOG.info("Adjust virtual cores requirement from {} to {}.", (Object)cores, (Object)updatedCores);
        }
        int updatedMemory = Math.min(resource.getMemory(), this.maxCapability.getMemory());
        if (resource.getMemory() != updatedMemory) {
            LOG.info("Adjust memory requirement from {} to {} MB.", (Object)resource.getMemory(), (Object)updatedMemory);
            resource.setMemory(updatedMemory);
        }
        return resource;
    }
}

