/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.appmaster.ApplicationMasterInfo;
import org.apache.twill.internal.appmaster.ApplicationMasterProcessLauncher;
import org.apache.twill.internal.appmaster.ApplicationSubmitter;
import org.apache.twill.internal.yarn.Hadoop21YarnApplicationReport;
import org.apache.twill.internal.yarn.YarnAppClient;
import org.apache.twill.internal.yarn.YarnApplicationReport;
import org.apache.twill.internal.yarn.YarnLaunchContext;
import org.apache.twill.internal.yarn.YarnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop21YarnAppClient
implements YarnAppClient {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop21YarnAppClient.class);
    protected final Configuration configuration;

    public Hadoop21YarnAppClient(Configuration configuration) {
        this.configuration = configuration;
    }

    private YarnClient createYarnClient() {
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init(this.configuration);
        yarnClient.start();
        return yarnClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessLauncher<ApplicationMasterInfo> createLauncher(TwillSpecification twillSpec, @Nullable String schedulerQueue) throws Exception {
        YarnClient yarnClient = this.createYarnClient();
        try {
            YarnClientApplication application = yarnClient.createApplication();
            GetNewApplicationResponse response = application.getNewApplicationResponse();
            final ApplicationId appId = response.getApplicationId();
            final ApplicationSubmissionContext appSubmissionContext = application.getApplicationSubmissionContext();
            appSubmissionContext.setApplicationId(appId);
            appSubmissionContext.setApplicationName(twillSpec.getName());
            if (schedulerQueue != null) {
                appSubmissionContext.setQueue(schedulerQueue);
            }
            int memoryMB = this.configuration.getInt("twill.yarn.am.memory.mb", 512);
            final Resource capability = this.adjustMemory(response, Resource.newInstance((int)memoryMB, (int)1));
            ApplicationMasterInfo appMasterInfo = new ApplicationMasterInfo(appId, capability.getMemory(), capability.getVirtualCores());
            ApplicationSubmitter submitter = new ApplicationSubmitter(){

                @Override
                public ProcessController<YarnApplicationReport> submit(YarnLaunchContext context) {
                    ContainerLaunchContext launchContext = (ContainerLaunchContext)context.getLaunchContext();
                    YarnClient yarnClient = Hadoop21YarnAppClient.this.createYarnClient();
                    try {
                        Hadoop21YarnAppClient.this.addRMToken(launchContext, yarnClient, appId);
                        appSubmissionContext.setAMContainerSpec(launchContext);
                        appSubmissionContext.setResource(capability);
                        Hadoop21YarnAppClient.this.configureAppSubmissionContext(appSubmissionContext);
                        yarnClient.submitApplication(appSubmissionContext);
                        ProcessControllerImpl processControllerImpl = new ProcessControllerImpl(appId);
                        return processControllerImpl;
                    }
                    catch (IOException | YarnException e) {
                        throw new RuntimeException("Failed to submit application " + appId, e);
                    }
                    finally {
                        yarnClient.stop();
                    }
                }
            };
            ApplicationMasterProcessLauncher applicationMasterProcessLauncher = new ApplicationMasterProcessLauncher(appMasterInfo, submitter);
            return applicationMasterProcessLauncher;
        }
        finally {
            yarnClient.stop();
        }
    }

    protected void configureAppSubmissionContext(ApplicationSubmissionContext context) {
        int maxAttempts = this.configuration.getInt("twill.yarn.max.app.attempts", -1);
        if (maxAttempts > 0) {
            context.setMaxAppAttempts(maxAttempts);
        } else {
            context.setMaxAppAttempts(2);
        }
    }

    private Resource adjustMemory(GetNewApplicationResponse response, Resource capability) {
        int maxMemory = response.getMaximumResourceCapability().getMemory();
        int updatedMemory = capability.getMemory();
        if (updatedMemory > maxMemory) {
            capability.setMemory(maxMemory);
        }
        return capability;
    }

    protected void addRMToken(ContainerLaunchContext context, YarnClient yarnClient, ApplicationId appId) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            Credentials credentials = YarnUtils.decodeCredentials(context.getTokens());
            Configuration config = yarnClient.getConfig();
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)yarnClient.getRMDelegationToken(new Text(YarnUtils.getYarnTokenRenewer(config))), (InetSocketAddress)YarnUtils.getRMAddress(config));
            LOG.debug("Added RM delegation token {} for application {}", (Object)token, (Object)appId);
            credentials.addToken(token.getService(), token);
            context.setTokens(YarnUtils.encodeCredentials(credentials));
        }
        catch (IOException | YarnException e) {
            throw new RuntimeException("Failed to acquire RM delegation token", e);
        }
    }

    @Override
    public ProcessLauncher<ApplicationMasterInfo> createLauncher(String user, TwillSpecification twillSpec, @Nullable String schedulerQueue) throws Exception {
        return this.createLauncher(twillSpec, schedulerQueue);
    }

    @Override
    public ProcessController<YarnApplicationReport> createProcessController(ApplicationId appId) {
        return new ProcessControllerImpl(appId);
    }

    @Override
    public List<NodeReport> getNodeReports() throws Exception {
        YarnClient yarnClient = this.createYarnClient();
        try {
            List list = yarnClient.getNodeReports(new NodeState[0]);
            return list;
        }
        finally {
            yarnClient.stop();
        }
    }

    private final class ProcessControllerImpl
    implements ProcessController<YarnApplicationReport> {
        private final ApplicationId appId;

        ProcessControllerImpl(ApplicationId appId) {
            this.appId = appId;
        }

        public YarnApplicationReport getReport() {
            YarnClient yarnClient = Hadoop21YarnAppClient.this.createYarnClient();
            try {
                Hadoop21YarnApplicationReport hadoop21YarnApplicationReport = new Hadoop21YarnApplicationReport(yarnClient.getApplicationReport(this.appId));
                return hadoop21YarnApplicationReport;
            }
            catch (IOException | YarnException e) {
                throw new RuntimeException("Failed to get application report for " + this.appId, e);
            }
            finally {
                yarnClient.stop();
            }
        }

        public void cancel() {
            YarnClient yarnClient = Hadoop21YarnAppClient.this.createYarnClient();
            try {
                yarnClient.killApplication(this.appId);
            }
            catch (IOException | YarnException e) {
                throw new RuntimeException("Failed to kill application " + this.appId, e);
            }
            finally {
                yarnClient.stop();
            }
        }

        public void close() throws Exception {
        }
    }
}

