/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Throwables;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.twill.internal.yarn.YarnContainerInfo;

public final class Hadoop21YarnContainerInfo
implements YarnContainerInfo {
    private final Container container;

    public Hadoop21YarnContainerInfo(Container container) {
        this.container = container;
    }

    @Override
    public <T> T getContainer() {
        return (T)this.container;
    }

    public String getId() {
        return this.container.getId().toString();
    }

    public InetAddress getHost() {
        try {
            return InetAddress.getByName(this.container.getNodeId().getHost());
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public int getPort() {
        return this.container.getNodeId().getPort();
    }

    public int getMemoryMB() {
        return this.container.getResource().getMemory();
    }

    public int getVirtualCores() {
        return this.container.getResource().getVirtualCores();
    }
}

