/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.util.Records;
import org.apache.twill.internal.yarn.YarnLaunchContext;
import org.apache.twill.internal.yarn.YarnLocalResource;
import org.apache.twill.internal.yarn.YarnUtils;

public final class Hadoop21YarnLaunchContext
implements YarnLaunchContext {
    private static final Function<YarnLocalResource, LocalResource> RESOURCE_TRANSFORM = new Function<YarnLocalResource, LocalResource>(){

        public LocalResource apply(YarnLocalResource input) {
            return (LocalResource)input.getLocalResource();
        }
    };
    private final ContainerLaunchContext launchContext = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);

    @Override
    public <T> T getLaunchContext() {
        return (T)this.launchContext;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.launchContext.setTokens(YarnUtils.encodeCredentials(credentials));
    }

    @Override
    public void setLocalResources(Map<String, YarnLocalResource> localResources) {
        this.launchContext.setLocalResources(Maps.transformValues(localResources, RESOURCE_TRANSFORM));
    }

    @Override
    public void setServiceData(Map<String, ByteBuffer> serviceData) {
        this.launchContext.setServiceData(serviceData);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.launchContext.getEnvironment();
    }

    @Override
    public void setEnvironment(Map<String, String> environment) {
        this.launchContext.setEnvironment(environment);
    }

    @Override
    public List<String> getCommands() {
        return this.launchContext.getCommands();
    }

    @Override
    public void setCommands(List<String> commands) {
        this.launchContext.setCommands(commands);
    }

    @Override
    public void setApplicationACLs(Map<ApplicationAccessType, String> acls) {
        this.launchContext.setApplicationACLs(acls);
    }
}

