/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.twill.common.Cancellable;
import org.apache.twill.internal.yarn.YarnContainerInfo;
import org.apache.twill.internal.yarn.YarnLaunchContext;
import org.apache.twill.internal.yarn.YarnNMClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Hadoop21YarnNMClient
extends AbstractIdleService
implements YarnNMClient {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop21YarnNMClient.class);
    private final NMClient nmClient = NMClient.createNMClient();

    public Hadoop21YarnNMClient(Configuration configuration) {
        this.nmClient.init(configuration);
    }

    @Override
    public Cancellable start(YarnContainerInfo containerInfo, YarnLaunchContext launchContext) {
        try {
            Container container = (Container)containerInfo.getContainer();
            this.nmClient.startContainer(container, (ContainerLaunchContext)launchContext.getLaunchContext());
            return new ContainerTerminator(container, this.nmClient);
        }
        catch (Exception e) {
            LOG.error("Error in launching process", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void startUp() throws Exception {
        this.nmClient.start();
    }

    protected void shutDown() throws Exception {
        this.nmClient.stop();
    }

    private static final class ContainerTerminator
    implements Cancellable {
        private final Container container;
        private final NMClient nmClient;

        private ContainerTerminator(Container container, NMClient nmClient) {
            this.container = container;
            this.nmClient = nmClient;
        }

        public void cancel() {
            LOG.info("Request to stop container {}.", (Object)this.container.getId());
            try {
                this.nmClient.stopContainer(this.container.getId(), this.container.getNodeId());
                while (true) {
                    ContainerStatus status = this.nmClient.getContainerStatus(this.container.getId(), this.container.getNodeId());
                    LOG.trace("Container status: {} {}", (Object)status, (Object)status.getDiagnostics());
                    if (status.getState() == ContainerState.COMPLETE) break;
                    Uninterruptibles.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                LOG.info("Container {} stopped.", (Object)this.container.getId());
            }
            catch (Exception e) {
                LOG.error("Fail to stop container {}", (Object)this.container.getId(), (Object)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

