/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.twill.internal.yarn.Hadoop21YarnAppClient;
import org.apache.twill.internal.yarn.YarnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop23YarnAppClient
extends Hadoop21YarnAppClient {
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop23YarnAppClient.class);

    public Hadoop23YarnAppClient(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected void addRMToken(ContainerLaunchContext context, YarnClient yarnClient, ApplicationId appId) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            Text renewer = new Text(UserGroupInformation.getCurrentUser().getShortUserName());
            org.apache.hadoop.yarn.api.records.Token rmDelegationToken = yarnClient.getRMDelegationToken(renewer);
            ArrayList<String> services = new ArrayList<String>();
            if (HAUtil.isHAEnabled((Configuration)this.configuration)) {
                YarnConfiguration yarnConf = new YarnConfiguration(this.configuration);
                for (String rmId : HAUtil.getRMHAIds((Configuration)this.configuration)) {
                    yarnConf.set("yarn.resourcemanager.ha.id", rmId);
                    InetSocketAddress address = yarnConf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
                    services.add(SecurityUtil.buildTokenService((InetSocketAddress)address).toString());
                }
            } else {
                services.add(SecurityUtil.buildTokenService((InetSocketAddress)YarnUtils.getRMAddress(this.configuration)).toString());
            }
            Credentials credentials = YarnUtils.decodeCredentials(context.getTokens());
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)rmDelegationToken, (InetSocketAddress)null);
            token.setService(new Text(Joiner.on((char)',').join(services)));
            credentials.addToken(new Text(token.getService()), token);
            LOG.debug("Added RM delegation token {} for application {}", (Object)token, (Object)appId);
            credentials.addToken(token.getService(), token);
            context.setTokens(YarnUtils.encodeCredentials(credentials));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

