/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Service;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.yarn.YarnContainerInfo;
import org.apache.twill.internal.yarn.YarnContainerStatus;

public interface YarnAMClient
extends Service {
    public ContainerId getContainerId();

    public String getHost();

    public int getNMPort();

    public void setTracker(InetSocketAddress var1, URL var2);

    public void allocate(float var1, AllocateHandler var2) throws Exception;

    public ContainerRequestBuilder addContainerRequest(Resource var1, int var2);

    public void addToBlacklist(String var1);

    public void removeFromBlacklist(String var1);

    public void clearBlacklist();

    public void completeContainerRequest(String var1);

    public static interface AllocateHandler {
        public void acquired(List<? extends ProcessLauncher<YarnContainerInfo>> var1);

        public void completed(List<YarnContainerStatus> var1);
    }

    public static abstract class ContainerRequestBuilder {
        protected final Resource capability;
        protected final int count;
        protected final Set<String> hosts = Sets.newHashSet();
        protected final Set<String> racks = Sets.newHashSet();
        protected final Priority priority = (Priority)Records.newRecord(Priority.class);
        protected boolean relaxLocality;

        protected ContainerRequestBuilder(Resource capability, int count) {
            this.capability = capability;
            this.count = count;
            this.relaxLocality = true;
        }

        public ContainerRequestBuilder addHosts(Collection<String> newHosts) {
            return this.add(this.hosts, newHosts);
        }

        public ContainerRequestBuilder addRacks(Collection<String> newRacks) {
            return this.add(this.racks, newRacks);
        }

        public ContainerRequestBuilder setPriority(int prio) {
            this.priority.setPriority(prio);
            return this;
        }

        public ContainerRequestBuilder setRelaxLocality(boolean relaxLocality) {
            this.relaxLocality = relaxLocality;
            return this;
        }

        public abstract String apply();

        private <T> ContainerRequestBuilder add(Collection<T> collection, Collection<T> more) {
            if (more != null) {
                collection.addAll(more);
            }
            return this;
        }
    }
}

