/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.yarn;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import org.apache.twill.api.LocalFile;
import org.apache.twill.internal.appmaster.ApplicationMasterLiveNodeData;
import org.apache.twill.internal.json.LocalFileCodec;
import org.apache.twill.zookeeper.NodeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApplicationMasterLiveNodeDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMasterLiveNodeDecoder.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(LocalFile.class, (Object)new LocalFileCodec()).create();

    @Nullable
    static ApplicationMasterLiveNodeData decode(@Nullable NodeData nodeData) {
        byte[] data;
        byte[] byArray = data = nodeData == null ? null : nodeData.getData();
        if (data == null) {
            return null;
        }
        JsonElement json = (JsonElement)GSON.fromJson(new String(data, Charsets.UTF_8), JsonElement.class);
        if (!json.isJsonObject()) {
            LOG.warn("Unable to decode live data node.");
            return null;
        }
        JsonObject jsonObj = json.getAsJsonObject();
        if ((json = jsonObj.get("data")) == null || !json.isJsonObject()) {
            LOG.warn("Property data not found in live data node.");
            return null;
        }
        try {
            return (ApplicationMasterLiveNodeData)GSON.fromJson(json, ApplicationMasterLiveNodeData.class);
        }
        catch (Exception e) {
            LOG.warn("Failed to decode application live node data.", (Throwable)e);
            return null;
        }
    }

    private ApplicationMasterLiveNodeDecoder() {
    }
}

