/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.yarn;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.twill.api.RunId;
import org.apache.twill.api.security.SecureStoreRenewer;
import org.apache.twill.api.security.SecureStoreWriter;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.internal.yarn.YarnUtils;
import org.apache.twill.yarn.YarnSecureStore;

final class LocationSecureStoreRenewer
extends SecureStoreRenewer {
    private final Configuration configuration;
    private final LocationFactory locationFactory;

    LocationSecureStoreRenewer(Configuration configuration, LocationFactory locationFactory) {
        this.configuration = configuration;
        this.locationFactory = locationFactory;
    }

    public void renew(String application, RunId runId, SecureStoreWriter secureStoreWriter) throws IOException {
        Credentials credentials = new Credentials();
        YarnUtils.addDelegationTokens(this.configuration, this.locationFactory, credentials);
        secureStoreWriter.write(YarnSecureStore.create(credentials));
    }
}

