/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.yarn;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import joptsimple.OptionSpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.twill.api.ClassAcceptor;
import org.apache.twill.api.Configs;
import org.apache.twill.api.EventHandlerSpecification;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.RunId;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.SecureStore;
import org.apache.twill.api.TwillController;
import org.apache.twill.api.TwillPreparer;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.api.logging.LogEntry;
import org.apache.twill.api.logging.LogHandler;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.internal.ApplicationBundler;
import org.apache.twill.internal.Arguments;
import org.apache.twill.internal.DefaultLocalFile;
import org.apache.twill.internal.DefaultRuntimeSpecification;
import org.apache.twill.internal.DefaultTwillSpecification;
import org.apache.twill.internal.JvmOptions;
import org.apache.twill.internal.LogOnlyEventHandler;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.TwillRuntimeSpecification;
import org.apache.twill.internal.appmaster.ApplicationMasterInfo;
import org.apache.twill.internal.appmaster.ApplicationMasterMain;
import org.apache.twill.internal.container.TwillContainerMain;
import org.apache.twill.internal.io.LocationCache;
import org.apache.twill.internal.json.ArgumentsCodec;
import org.apache.twill.internal.json.LocalFileCodec;
import org.apache.twill.internal.json.TwillRuntimeSpecificationAdapter;
import org.apache.twill.internal.utils.Dependencies;
import org.apache.twill.internal.utils.Paths;
import org.apache.twill.internal.utils.Resources;
import org.apache.twill.internal.yarn.VersionDetectYarnAppClientFactory;
import org.apache.twill.internal.yarn.YarnAppClient;
import org.apache.twill.internal.yarn.YarnApplicationReport;
import org.apache.twill.internal.yarn.YarnUtils;
import org.apache.twill.launcher.FindFreePort;
import org.apache.twill.launcher.TwillLauncher;
import org.apache.twill.yarn.YarnTwillController;
import org.apache.twill.yarn.YarnTwillControllerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YarnTwillPreparer
implements TwillPreparer {
    private static final Logger LOG = LoggerFactory.getLogger(YarnTwillPreparer.class);
    private final Configuration config;
    private final TwillSpecification twillSpec;
    private final String zkConnectString;
    private final Location appLocation;
    private final YarnTwillControllerFactory controllerFactory;
    private final RunId runId;
    private final List<LogHandler> logHandlers = Lists.newArrayList();
    private final List<String> arguments = Lists.newArrayList();
    private final Set<Class<?>> dependencies = Sets.newIdentityHashSet();
    private final List<URI> resources = Lists.newArrayList();
    private final List<String> classPaths = Lists.newArrayList();
    private final ListMultimap<String, String> runnableArgs = ArrayListMultimap.create();
    private final Map<String, Map<String, String>> environments = Maps.newHashMap();
    private final List<String> applicationClassPaths = Lists.newArrayList();
    private final Credentials credentials;
    private final Map<String, Map<String, String>> logLevels = Maps.newHashMap();
    private final LocationCache locationCache;
    private final Map<String, Integer> maxRetries = Maps.newHashMap();
    private final Map<String, Map<String, String>> runnableConfigs = Maps.newHashMap();
    private final Map<String, String> runnableExtraOptions = Maps.newHashMap();
    private String extraOptions;
    private JvmOptions.DebugOptions debugOptions = JvmOptions.DebugOptions.NO_DEBUG;
    private String schedulerQueue;
    private ClassAcceptor classAcceptor;
    private String classLoaderClassName;

    YarnTwillPreparer(Configuration config, TwillSpecification twillSpec, RunId runId, String zkConnectString, Location appLocation, @Nullable String extraOptions, LocationCache locationCache, YarnTwillControllerFactory controllerFactory) {
        this.config = config;
        this.twillSpec = twillSpec;
        this.runId = runId;
        this.zkConnectString = zkConnectString;
        this.appLocation = appLocation;
        this.controllerFactory = controllerFactory;
        this.credentials = this.createCredentials();
        this.extraOptions = extraOptions == null ? "" : extraOptions;
        this.classAcceptor = new ClassAcceptor();
        this.locationCache = locationCache;
    }

    private void confirmRunnableName(String runnableName) {
        Preconditions.checkNotNull((Object)runnableName);
        Preconditions.checkArgument((boolean)this.twillSpec.getRunnables().containsKey(runnableName), (String)"Runnable %s is not defined in the application.", (Object[])new Object[]{runnableName});
    }

    public TwillPreparer withConfiguration(Map<String, String> config) {
        for (Map.Entry<String, String> entry : config.entrySet()) {
            this.config.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public TwillPreparer withConfiguration(String runnableName, Map<String, String> config) {
        this.confirmRunnableName(runnableName);
        this.runnableConfigs.put(runnableName, Maps.newHashMap(config));
        return this;
    }

    public TwillPreparer addLogHandler(LogHandler handler) {
        this.logHandlers.add(handler);
        return this;
    }

    public TwillPreparer setUser(String user) {
        return this;
    }

    public TwillPreparer setSchedulerQueue(String name) {
        this.schedulerQueue = name;
        return this;
    }

    public TwillPreparer setJVMOptions(String options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"JVM options cannot be null.");
        this.extraOptions = options;
        return this;
    }

    public TwillPreparer setJVMOptions(String runnableName, String options) {
        this.confirmRunnableName(runnableName);
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"JVM options cannot be null.");
        this.runnableExtraOptions.put(runnableName, options);
        return this;
    }

    public TwillPreparer addJVMOptions(String options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"JVM options cannot be null.");
        this.extraOptions = this.extraOptions.isEmpty() ? options : this.extraOptions + " " + options;
        return this;
    }

    public TwillPreparer enableDebugging(String ... runnables) {
        return this.enableDebugging(false, runnables);
    }

    public TwillPreparer enableDebugging(boolean doSuspend, String ... runnables) {
        for (String runnableName : runnables) {
            this.confirmRunnableName(runnableName);
        }
        this.debugOptions = new JvmOptions.DebugOptions(true, doSuspend, (Iterable)ImmutableSet.copyOf((Object[])runnables));
        return this;
    }

    public TwillPreparer withApplicationArguments(String ... args) {
        return this.withApplicationArguments((Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public TwillPreparer withApplicationArguments(Iterable<String> args) {
        Iterables.addAll(this.arguments, args);
        return this;
    }

    public TwillPreparer withArguments(String runnableName, String ... args) {
        return this.withArguments(runnableName, (Iterable<String>)ImmutableList.copyOf((Object[])args));
    }

    public TwillPreparer withArguments(String runnableName, Iterable<String> args) {
        this.confirmRunnableName(runnableName);
        this.runnableArgs.putAll((Object)runnableName, args);
        return this;
    }

    public TwillPreparer withDependencies(Class<?> ... classes) {
        return this.withDependencies((Iterable<Class<?>>)ImmutableList.copyOf((Object[])classes));
    }

    public TwillPreparer withDependencies(Iterable<Class<?>> classes) {
        Iterables.addAll(this.dependencies, classes);
        return this;
    }

    public TwillPreparer withResources(URI ... resources) {
        return this.withResources((Iterable<URI>)ImmutableList.copyOf((Object[])resources));
    }

    public TwillPreparer withResources(Iterable<URI> resources) {
        Iterables.addAll(this.resources, resources);
        return this;
    }

    public TwillPreparer withClassPaths(String ... classPaths) {
        return this.withClassPaths((Iterable<String>)ImmutableList.copyOf((Object[])classPaths));
    }

    public TwillPreparer withClassPaths(Iterable<String> classPaths) {
        Iterables.addAll(this.classPaths, classPaths);
        return this;
    }

    public TwillPreparer withEnv(Map<String, String> env) {
        for (String runnableName : this.twillSpec.getRunnables().keySet()) {
            this.setEnv(runnableName, env, false);
        }
        return this;
    }

    public TwillPreparer withEnv(String runnableName, Map<String, String> env) {
        this.confirmRunnableName(runnableName);
        this.setEnv(runnableName, env, true);
        return this;
    }

    public TwillPreparer withApplicationClassPaths(String ... classPaths) {
        return this.withApplicationClassPaths((Iterable<String>)ImmutableList.copyOf((Object[])classPaths));
    }

    public TwillPreparer withApplicationClassPaths(Iterable<String> classPaths) {
        Iterables.addAll(this.applicationClassPaths, classPaths);
        return this;
    }

    public TwillPreparer withBundlerClassAcceptor(ClassAcceptor classAcceptor) {
        this.classAcceptor = classAcceptor;
        return this;
    }

    public TwillPreparer withMaxRetries(String runnableName, int maxRetries) {
        this.confirmRunnableName(runnableName);
        this.maxRetries.put(runnableName, maxRetries);
        return this;
    }

    public TwillPreparer addSecureStore(SecureStore secureStore) {
        Object store = secureStore.getStore();
        Preconditions.checkArgument((boolean)(store instanceof Credentials), (Object)"Only Hadoop Credentials is supported.");
        this.credentials.mergeAll((Credentials)store);
        return this;
    }

    public TwillPreparer setLogLevel(LogEntry.Level logLevel) {
        return this.setLogLevels((Map<String, LogEntry.Level>)ImmutableMap.of((Object)"ROOT", (Object)logLevel));
    }

    public TwillPreparer setLogLevels(Map<String, LogEntry.Level> logLevels) {
        Preconditions.checkNotNull(logLevels);
        for (String runnableName : this.twillSpec.getRunnables().keySet()) {
            this.saveLogLevels(runnableName, logLevels);
        }
        return this;
    }

    public TwillPreparer setLogLevels(String runnableName, Map<String, LogEntry.Level> runnableLogLevels) {
        this.confirmRunnableName(runnableName);
        Preconditions.checkNotNull(runnableLogLevels);
        Preconditions.checkArgument((!this.logLevels.containsKey("ROOT") || this.logLevels.get("ROOT") != null ? 1 : 0) != 0);
        this.saveLogLevels(runnableName, runnableLogLevels);
        return this;
    }

    public TwillPreparer setClassLoader(String classLoaderClassName) {
        this.classLoaderClassName = classLoaderClassName;
        return this;
    }

    public TwillController start() {
        return this.start(60L, TimeUnit.SECONDS);
    }

    public TwillController start(long timeout, TimeUnit timeoutUnit) {
        try {
            final YarnAppClient yarnAppClient = new VersionDetectYarnAppClientFactory().create(this.config);
            final ProcessLauncher<ApplicationMasterInfo> launcher = yarnAppClient.createLauncher(this.twillSpec, this.schedulerQueue);
            final ApplicationMasterInfo appMasterInfo = (ApplicationMasterInfo)launcher.getContainerInfo();
            Callable<ProcessController<YarnApplicationReport>> submitTask = new Callable<ProcessController<YarnApplicationReport>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ProcessController<YarnApplicationReport> call() throws Exception {
                    JvmOptions jvmOptions;
                    TwillRuntimeSpecification twillRuntimeSpec;
                    HashMap localFiles = Maps.newHashMap();
                    YarnTwillPreparer.this.createLauncherJar(localFiles);
                    YarnTwillPreparer.this.createTwillJar(YarnTwillPreparer.this.createBundler(YarnTwillPreparer.this.classAcceptor), yarnAppClient, localFiles);
                    YarnTwillPreparer.this.createApplicationJar(YarnTwillPreparer.this.createBundler(YarnTwillPreparer.this.classAcceptor), localFiles);
                    YarnTwillPreparer.this.createResourcesJar(YarnTwillPreparer.this.createBundler(YarnTwillPreparer.this.classAcceptor), localFiles);
                    Path runtimeConfigDir = Files.createTempDirectory(YarnTwillPreparer.this.getLocalStagingDir().toPath(), "runtime.config.jar", new FileAttribute[0]);
                    try {
                        twillRuntimeSpec = YarnTwillPreparer.this.saveSpecification(YarnTwillPreparer.this.twillSpec, runtimeConfigDir.resolve("twillSpec.json"));
                        YarnTwillPreparer.this.saveLogback(runtimeConfigDir.resolve("logback-template.xml"));
                        YarnTwillPreparer.this.saveClassPaths(runtimeConfigDir);
                        jvmOptions = YarnTwillPreparer.this.saveJvmOptions(runtimeConfigDir.resolve("jvm.opts.json"));
                        YarnTwillPreparer.this.saveArguments(new Arguments(YarnTwillPreparer.this.arguments, (Multimap)YarnTwillPreparer.this.runnableArgs), runtimeConfigDir.resolve("arguments.json"));
                        YarnTwillPreparer.this.saveEnvironments(runtimeConfigDir.resolve("environments.json"));
                        YarnTwillPreparer.this.createRuntimeConfigJar(runtimeConfigDir, localFiles);
                    }
                    finally {
                        Paths.deleteRecursively((Path)runtimeConfigDir);
                    }
                    YarnTwillPreparer.this.createLocalizeFilesJson(localFiles);
                    LOG.debug("Submit AM container spec: {}", (Object)appMasterInfo);
                    int memory = Resources.computeMaxHeapSize((int)appMasterInfo.getMemoryMB(), (int)twillRuntimeSpec.getAMReservedMemory(), (double)twillRuntimeSpec.getAMMinHeapRatio());
                    return launcher.prepareLaunch((Map)ImmutableMap.of(), localFiles.values(), (Object)YarnTwillPreparer.this.createSubmissionCredentials()).addCommand("$JAVA_HOME/bin/java", new String[]{"-Djava.io.tmpdir=tmp", "-Dyarn.appId=$YARN_APP_ID_STR", "-Dtwill.app=$TWILL_APP_NAME", "-cp", "launcher.jar:$HADOOP_CONF_DIR", "-Xmx" + memory + "m", jvmOptions.getAMExtraOptions(), TwillLauncher.class.getName(), ApplicationMasterMain.class.getName(), Boolean.FALSE.toString()}).launch();
                }
            };
            YarnTwillController controller = this.controllerFactory.create(this.runId, this.isLogCollectionEnabled(), this.logHandlers, submitTask, timeout, timeoutUnit);
            controller.start();
            return controller;
        }
        catch (Exception e) {
            LOG.error("Failed to submit application {}", (Object)this.twillSpec.getName(), (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean isLogCollectionEnabled() {
        return this.config.getBoolean("twill.log.collection.enabled", true);
    }

    private File getLocalStagingDir() {
        return new File(this.config.get("twill.local.staging.dir", Configs.Defaults.LOCAL_STAGING_DIRECTORY));
    }

    private String addClassLoaderClassName(String extraOptions) {
        if (this.classLoaderClassName == null) {
            return extraOptions;
        }
        String classLoaderProperty = "-Dtwill.container.class.loader=" + this.classLoaderClassName;
        return extraOptions.isEmpty() ? classLoaderProperty : extraOptions + " " + classLoaderProperty;
    }

    private void setEnv(String runnableName, Map<String, String> env, boolean overwrite) {
        Map<String, String> environment = this.environments.get(runnableName);
        if (environment == null) {
            environment = new LinkedHashMap<String, String>(env);
            this.environments.put(runnableName, environment);
            return;
        }
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!overwrite && environment.containsKey(entry.getKey())) continue;
            environment.put(entry.getKey(), entry.getValue());
        }
    }

    private void saveLogLevels(String runnableName, Map<String, LogEntry.Level> logLevels) {
        HashMap<String, String> newLevels = new HashMap<String, String>();
        for (Map.Entry<String, LogEntry.Level> entry : logLevels.entrySet()) {
            Preconditions.checkArgument((entry.getValue() != null ? 1 : 0) != 0, (String)"Log level cannot be null for logger {}", (Object[])new Object[]{entry.getKey()});
            newLevels.put(entry.getKey(), entry.getValue().name());
        }
        this.logLevels.put(runnableName, newLevels);
    }

    private Credentials createCredentials() {
        Credentials credentials = new Credentials();
        try {
            credentials.addAll(UserGroupInformation.getCurrentUser().getCredentials());
        }
        catch (IOException e) {
            LOG.warn("Failed to get current user UGI. Current user credentials not added.", (Throwable)e);
        }
        return credentials;
    }

    private Credentials createSubmissionCredentials() {
        Credentials credentials = new Credentials();
        try {
            List<Token<?>> tokens = YarnUtils.addDelegationTokens(this.config, this.appLocation.getLocationFactory(), credentials);
            if (LOG.isDebugEnabled()) {
                for (Token<?> token : tokens) {
                    LOG.debug("Delegation token acquired for {}, {}", (Object)this.appLocation, token);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to acquire delegation token for location {}", (Object)this.appLocation);
        }
        credentials.addAll(this.credentials);
        return credentials;
    }

    private LocalFile createLocalFile(String name, Location location) throws IOException {
        return this.createLocalFile(name, location, false);
    }

    private LocalFile createLocalFile(String name, Location location, boolean archive) throws IOException {
        return new DefaultLocalFile(name, location.toURI(), location.lastModified(), location.length(), archive, null);
    }

    private void createTwillJar(final ApplicationBundler bundler, final YarnAppClient yarnAppClient, Map<String, LocalFile> localFiles) throws IOException {
        LOG.debug("Create and copy {}", (Object)"twill.jar");
        Location location = this.locationCache.get("twill.jar", new LocationCache.Loader(){

            public void load(String name, Location targetLocation) throws IOException {
                ArrayList<Class> depClasses = new ArrayList<Class>(Arrays.asList(ApplicationMasterMain.class, yarnAppClient.getClass(), TwillContainerMain.class));
                if (YarnTwillPreparer.this.isLogCollectionEnabled()) {
                    depClasses.add(OptionSpec.class);
                }
                bundler.createBundle(targetLocation, depClasses);
            }
        });
        LOG.debug("Done {}", (Object)"twill.jar");
        localFiles.put("twill.jar", this.createLocalFile("twill.jar", location, true));
    }

    private void createApplicationJar(final ApplicationBundler bundler, Map<String, LocalFile> localFiles) throws IOException {
        try {
            final Set classes = Sets.newIdentityHashSet();
            classes.addAll(this.dependencies);
            ClassLoader classLoader = this.getClassLoader();
            for (RuntimeSpecification spec : this.twillSpec.getRunnables().values()) {
                classes.add(classLoader.loadClass(spec.getRunnableSpecification().getClassName()));
            }
            if (this.twillSpec.getEventHandler() != null) {
                classes.add(classLoader.loadClass(this.twillSpec.getEventHandler().getClassName()));
            }
            if (this.classLoaderClassName != null) {
                try {
                    classes.add(classLoader.loadClass(this.classLoaderClassName));
                }
                catch (ClassNotFoundException e) {
                    LOG.debug("Cannot load custom classloader class '{}' when preparing for application launch", (Object)this.classLoaderClassName);
                }
            }
            List classList = classes.stream().map(Class::getName).sorted().collect(Collectors.toList());
            Hasher hasher = Hashing.md5().newHasher();
            for (String name : classList) {
                hasher.putString((CharSequence)name);
            }
            String name = hasher.hash().toString() + "-" + "application.jar";
            LOG.debug("Create and copy {}", (Object)"application.jar");
            Location location = this.locationCache.get(name, new LocationCache.Loader(){

                public void load(String name, Location targetLocation) throws IOException {
                    bundler.createBundle(targetLocation, (Iterable)classes);
                }
            });
            LOG.debug("Done {}", (Object)"application.jar");
            localFiles.put("application.jar", this.createLocalFile("application.jar", location, true));
        }
        catch (ClassNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void createResourcesJar(ApplicationBundler bundler, Map<String, LocalFile> localFiles) throws IOException {
        if (this.resources.isEmpty()) {
            return;
        }
        LOG.debug("Create and copy {}", (Object)"resources.jar");
        Location location = this.createTempLocation("resources.jar");
        bundler.createBundle(location, Collections.emptyList(), this.resources);
        LOG.debug("Done {}", (Object)"resources.jar");
        localFiles.put("resources.jar", this.createLocalFile("resources.jar", location, true));
    }

    private void createRuntimeConfigJar(Path dir, Map<String, LocalFile> localFiles) throws IOException {
        LOG.debug("Create and copy {}", (Object)"runtime.config.jar");
        Location location = this.createTempLocation("runtime.config.jar");
        try (JarOutputStream jarOutput = new JarOutputStream(location.getOutputStream());
             DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                jarOutput.putNextEntry(new JarEntry(path.getFileName().toString()));
                Files.copy(path, jarOutput);
                jarOutput.closeEntry();
            }
        }
        LOG.debug("Done {}", (Object)"runtime.config.jar");
        localFiles.put("runtime.config.jar", this.createLocalFile("runtime.config.jar", location, true));
    }

    private Multimap<String, LocalFile> populateRunnableLocalFiles(TwillSpecification twillSpec) throws IOException {
        HashMultimap localFiles = HashMultimap.create();
        LOG.debug("Populating Runnable LocalFiles");
        for (Map.Entry entry : twillSpec.getRunnables().entrySet()) {
            String runnableName = (String)entry.getKey();
            for (LocalFile localFile : ((RuntimeSpecification)entry.getValue()).getLocalFiles()) {
                Location location = null;
                URI uri = localFile.getURI();
                if (this.appLocation.toURI().getScheme().equals(uri.getScheme())) {
                    location = this.appLocation.getLocationFactory().create(uri);
                } else {
                    if (!"file".equals(uri.getScheme())) {
                        try {
                            Configuration contextConf = new Configuration(this.config);
                            contextConf.set("fs.defaultFS", uri.toString());
                            location = new FileContextLocationFactory(contextConf).create(uri);
                        }
                        catch (Exception e) {
                            LOG.debug("Failed to localize file from {} directly. Resort to copying.", (Object)uri);
                        }
                    }
                    if (location == null) {
                        URL url = uri.toURL();
                        LOG.debug("Create and copy {} : {}", (Object)runnableName, (Object)url);
                        location = this.copyFromURL(url, this.createTempLocation(Paths.addExtension((String)url.getFile(), (String)localFile.getName())));
                        LOG.debug("Done {} : {}", (Object)runnableName, (Object)url);
                    }
                }
                localFiles.put((Object)runnableName, (Object)new DefaultLocalFile(localFile.getName(), location.toURI(), location.lastModified(), location.length(), localFile.isArchive(), localFile.getPattern()));
            }
        }
        LOG.debug("Done Runnable LocalFiles");
        return localFiles;
    }

    private TwillRuntimeSpecification saveSpecification(TwillSpecification spec, Path targetFile) throws IOException {
        final Multimap<String, LocalFile> runnableLocalFiles = this.populateRunnableLocalFiles(spec);
        Map runtimeSpec = Maps.transformEntries((Map)spec.getRunnables(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, RuntimeSpecification, RuntimeSpecification>(){

            public RuntimeSpecification transformEntry(String key, RuntimeSpecification value) {
                return new DefaultRuntimeSpecification(value.getName(), value.getRunnableSpecification(), value.getResourceSpecification(), runnableLocalFiles.get((Object)key));
            }
        });
        LOG.debug("Creating {}", (Object)targetFile);
        try (BufferedWriter writer = Files.newBufferedWriter(targetFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            EventHandlerSpecification eventHandler = spec.getEventHandler();
            if (eventHandler == null) {
                eventHandler = new LogOnlyEventHandler().configure();
            }
            DefaultTwillSpecification newTwillSpec = new DefaultTwillSpecification(spec.getName(), runtimeSpec, spec.getOrders(), spec.getPlacementPolicies(), eventHandler);
            HashMap configMap = Maps.newHashMap();
            for (Map.Entry entry : this.config) {
                if (!((String)entry.getKey()).startsWith("twill.")) continue;
                configMap.put(entry.getKey(), entry.getValue());
            }
            TwillRuntimeSpecification twillRuntimeSpec = new TwillRuntimeSpecification((TwillSpecification)newTwillSpec, this.appLocation.getLocationFactory().getHomeLocation().getName(), this.appLocation.toURI(), this.zkConnectString, this.runId, this.twillSpec.getName(), this.config.get("yarn.resourcemanager.scheduler.address"), this.logLevels, this.maxRetries, (Map)configMap, this.runnableConfigs);
            TwillRuntimeSpecificationAdapter.create().toJson(twillRuntimeSpec, (Writer)writer);
            LOG.debug("Done {}", (Object)targetFile);
            TwillRuntimeSpecification twillRuntimeSpecification = twillRuntimeSpec;
            return twillRuntimeSpecification;
        }
    }

    private void saveLogback(Path targetFile) throws IOException {
        URL url = this.getClass().getClassLoader().getResource("logback-template.xml");
        if (url == null) {
            return;
        }
        LOG.debug("Creating {}", (Object)targetFile);
        try (InputStream is = url.openStream();){
            Files.copy(is, targetFile, new CopyOption[0]);
        }
        LOG.debug("Done {}", (Object)targetFile);
    }

    private void createLauncherJar(Map<String, LocalFile> localFiles) throws URISyntaxException, IOException {
        LOG.debug("Create and copy {}", (Object)"launcher.jar");
        Location location = this.locationCache.get("launcher.jar", new LocationCache.Loader(){

            public void load(String name, Location targetLocation) throws IOException {
                try (final JarOutputStream jarOut = new JarOutputStream(targetLocation.getOutputStream());){
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    }
                    Dependencies.findClassDependencies((ClassLoader)classLoader, (ClassAcceptor)new ClassAcceptor(){

                        public boolean accept(String className, URL classUrl, URL classPathUrl) {
                            try {
                                jarOut.putNextEntry(new JarEntry(className.replace('.', '/') + ".class"));
                                try (InputStream is = classUrl.openStream();){
                                    ByteStreams.copy((InputStream)is, (OutputStream)jarOut);
                                }
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                            return true;
                        }
                    }, (String[])new String[]{TwillLauncher.class.getName(), FindFreePort.class.getName()});
                }
            }
        });
        LOG.debug("Done {}", (Object)"launcher.jar");
        localFiles.put("launcher.jar", this.createLocalFile("launcher.jar", location));
    }

    private void saveClassPaths(Path targetDir) throws IOException {
        Files.write(targetDir.resolve("application-classpath.txt"), Joiner.on((char)':').join(this.applicationClassPaths).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(targetDir.resolve("classpath.txt"), Joiner.on((char)':').join(this.classPaths).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private JvmOptions saveJvmOptions(Path targetPath) throws IOException {
        HashMap runnableExtraOptions = Maps.newHashMap((Map)Maps.transformValues(this.runnableExtraOptions, (Function)new Function<String, String>(){

            public String apply(String options) {
                return YarnTwillPreparer.this.addClassLoaderClassName(YarnTwillPreparer.this.extraOptions.isEmpty() ? options : YarnTwillPreparer.this.extraOptions + " " + options);
            }
        }));
        String globalOptions = this.addClassLoaderClassName(this.extraOptions);
        JvmOptions jvmOptions = new JvmOptions(globalOptions, (Map)runnableExtraOptions, this.debugOptions);
        if (globalOptions.isEmpty() && runnableExtraOptions.isEmpty() && JvmOptions.DebugOptions.NO_DEBUG.equals((Object)this.debugOptions)) {
            return jvmOptions;
        }
        LOG.debug("Creating {}", (Object)targetPath);
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            new Gson().toJson((Object)new JvmOptions(globalOptions, (Map)runnableExtraOptions, this.debugOptions), (Appendable)writer);
        }
        LOG.debug("Done {}", (Object)targetPath);
        return jvmOptions;
    }

    private void saveArguments(Arguments arguments, final Path targetPath) throws IOException {
        LOG.debug("Creating {}", (Object)targetPath);
        ArgumentsCodec.encode((Arguments)arguments, (OutputSupplier)new OutputSupplier<Writer>(){

            public Writer getOutput() throws IOException {
                return Files.newBufferedWriter(targetPath, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        });
        LOG.debug("Done {}", (Object)targetPath);
    }

    private void saveEnvironments(Path targetPath) throws IOException {
        if (this.environments.isEmpty()) {
            return;
        }
        LOG.debug("Creating {}", (Object)targetPath);
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            new Gson().toJson(this.environments, (Appendable)writer);
        }
        LOG.debug("Done {}", (Object)targetPath);
    }

    private void createLocalizeFilesJson(Map<String, LocalFile> localFiles) throws IOException {
        LOG.debug("Create and copy {}", (Object)"localizeFiles.json");
        Location location = this.createTempLocation("localizeFiles.json");
        try (OutputStreamWriter writer = new OutputStreamWriter(location.getOutputStream(), StandardCharsets.UTF_8);){
            new GsonBuilder().registerTypeAdapter(LocalFile.class, (Object)new LocalFileCodec()).create().toJson(localFiles.values(), new TypeToken<List<LocalFile>>(){}.getType(), (Appendable)writer);
        }
        LOG.debug("Done {}", (Object)"localizeFiles.json");
        localFiles.put("localizeFiles.json", this.createLocalFile("localizeFiles.json", location));
    }

    private Location copyFromURL(URL url, Location target) throws IOException {
        try (InputStream is = url.openStream();
             BufferedOutputStream os = new BufferedOutputStream(target.getOutputStream());){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        return target;
    }

    private Location createTempLocation(String fileName) {
        String suffix = Paths.getExtension((String)fileName);
        String name = fileName.substring(0, fileName.length() - suffix.length() - 1);
        try {
            return this.appLocation.append(name).getTempFile('.' + suffix);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    private ApplicationBundler createBundler(ClassAcceptor classAcceptor) {
        return new ApplicationBundler(classAcceptor).setTempDir(this.getLocalStagingDir());
    }
}

