/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.twill.filesystem.FileContextLocation;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;

public class FileContextLocationFactory
implements LocationFactory {
    private final Configuration configuration;
    private final Path pathBase;
    private final LoadingCache<UserGroupInformation, FileContext> fileContextCache;

    public FileContextLocationFactory(Configuration configuration) {
        this(configuration, "/");
    }

    public FileContextLocationFactory(final Configuration configuration, String pathBase) {
        this.configuration = configuration;
        this.pathBase = new Path(pathBase.startsWith("/") ? pathBase : "/" + pathBase);
        int maxCacheSize = configuration.getInt("twill.file.context.cache.max.size", 100);
        this.fileContextCache = CacheBuilder.newBuilder().weakKeys().weakValues().maximumSize((long)maxCacheSize).build((CacheLoader)new CacheLoader<UserGroupInformation, FileContext>(){

            public FileContext load(UserGroupInformation ugi) throws Exception {
                return (FileContext)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileContext>(){

                    @Override
                    public FileContext run() throws UnsupportedFileSystemException {
                        return FileContext.getFileContext((Configuration)configuration);
                    }
                });
            }
        });
    }

    @Deprecated
    public FileContextLocationFactory(Configuration configuration, FileContext fc, String pathBase) {
        this(configuration, pathBase);
        this.fileContextCache.put((Object)fc.getUgi(), (Object)fc);
    }

    public Location create(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Path locationPath = path.isEmpty() ? this.pathBase : new Path(path);
        FileContext fc = this.getFileContext();
        locationPath = locationPath.makeQualified(fc.getDefaultFileSystem().getUri(), this.pathBase);
        return new FileContextLocation(this, fc, locationPath);
    }

    public Location create(URI uri) {
        FileContext fc = this.getFileContext();
        URI contextURI = fc.getWorkingDirectory().toUri();
        if (Objects.equals(contextURI.getScheme(), uri.getScheme()) && Objects.equals(contextURI.getAuthority(), uri.getAuthority())) {
            return new FileContextLocation(this, fc, new Path(uri));
        }
        if (uri.isAbsolute()) {
            Preconditions.checkArgument((boolean)Objects.equals(contextURI.getScheme(), uri.getScheme()), (String)"Only URI with '%s' scheme is supported", (Object[])new Object[]{contextURI.getScheme()});
            Path locationPath = new Path(uri).makeQualified(fc.getDefaultFileSystem().getUri(), this.pathBase);
            return new FileContextLocation(this, fc, locationPath);
        }
        return this.create(uri.getPath());
    }

    public Location getHomeLocation() {
        FileContext fc = this.getFileContext();
        return new FileContextLocation(this, fc, new Path(fc.getHomeDirectory().getParent(), fc.getUgi().getShortUserName()));
    }

    public FileContext getFileContext() {
        try {
            return (FileContext)this.fileContextCache.getUnchecked((Object)UserGroupInformation.getCurrentUser());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get current user information", e);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnsupportedFileSystemException) {
                String defaultURI = this.configuration.get("fs.defaultFS", "file:///");
                throw new IllegalStateException("File system with URI '" + defaultURI + "' is not supported", cause);
            }
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

