/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.FilterReply;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.twill.api.RunId;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.LocalLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.internal.CompositeService;
import org.apache.twill.internal.Services;
import org.apache.twill.internal.TwillRuntimeSpecification;
import org.apache.twill.internal.logging.KafkaAppender;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.RetryStrategy;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceMain {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceMain.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doMain(final Service mainService, Service ... prerequisites) throws Exception {
        if (this.getTwillRuntimeSpecification().isLogCollectionEnabled()) {
            this.configureLogger();
        }
        CompositeService requiredServices = new CompositeService(prerequisites);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                mainService.stopAndWait();
            }
        });
        ListenableFuture completion = Services.getCompletionFuture((Service)mainService);
        Throwable initFailure = null;
        try {
            try {
                LOG.info("Starting service {}.", (Object)mainService);
                Futures.allAsList((Iterable)((Iterable)Services.chainStart((Service)requiredServices, (Service[])new Service[]{mainService}).get())).get();
                LOG.info("Service {} started.", (Object)mainService);
            }
            catch (Throwable t) {
                LOG.error("Exception when starting service {}.", (Object)mainService, (Object)t);
                initFailure = t;
            }
            try {
                if (initFailure == null) {
                    completion.get();
                    LOG.info("Service {} completed.", (Object)mainService);
                }
            }
            catch (Throwable t) {
                LOG.error("Exception thrown from service {}.", (Object)mainService, (Object)t);
                throw Throwables.propagate((Throwable)t);
            }
        }
        finally {
            requiredServices.stopAndWait();
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            if (loggerFactory instanceof LoggerContext) {
                ((LoggerContext)loggerFactory).stop();
            }
            if (initFailure != null) {
                System.exit(10);
            }
        }
    }

    protected abstract String getHostname();

    protected abstract TwillRuntimeSpecification getTwillRuntimeSpecification();

    @Nullable
    protected abstract String getRunnableName();

    protected final Location createAppLocation(final Configuration conf, String fsUser, final URI appDir) {
        try {
            if ("file".equals(appDir.getScheme())) {
                return new LocalLocationFactory().create(appDir);
            }
            UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createRemoteUser((String)fsUser);
            return (Location)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Location>(){

                @Override
                public Location run() throws Exception {
                    Configuration hConf = new Configuration(conf);
                    URI defaultURI = appDir.getAuthority() == null || appDir.getAuthority().isEmpty() ? new URI(appDir.getScheme(), "", "/", null, null) : new URI(appDir.getScheme(), appDir.getAuthority(), null, null, null);
                    hConf.set("fs.defaultFS", defaultURI.toString());
                    return new FileContextLocationFactory(hConf).create(appDir);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to create application location for {}.", (Object)appDir);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected final ZKClientService createZKClient() {
        TwillRuntimeSpecification twillRuntimeSpec = this.getTwillRuntimeSpecification();
        return ZKClientServices.delegate((ZKClient)ZKClients.namespace((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)ZKClientService.Builder.of((String)twillRuntimeSpec.getZkConnectStr()).build(), (RetryStrategy)RetryStrategies.fixDelay((long)1L, (TimeUnit)TimeUnit.SECONDS))), (String)("/" + twillRuntimeSpec.getTwillAppName())));
    }

    private void configureLogger() throws MalformedURLException, JoranException {
        File twillLogback;
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (!(loggerFactory instanceof LoggerContext)) {
            return;
        }
        LoggerContext context = (LoggerContext)loggerFactory;
        ContextInitializer contextInitializer = new ContextInitializer(context);
        URL url = contextInitializer.findURLOfDefaultConfigurationFile(false);
        if (url == null && (twillLogback = new File("runtime.config.jar", "logback-template.xml")).exists()) {
            contextInitializer.configureByResource(twillLogback.toURI().toURL());
        }
        KafkaAppender kafkaAppender = this.getKafkaAppender(context);
        kafkaAppender.start();
        context.getLogger("ROOT").addAppender((Appender)kafkaAppender);
    }

    private KafkaAppender getKafkaAppender(LoggerContext context) {
        KafkaAppender kafkaAppender = new KafkaAppender();
        kafkaAppender.setName("KAFKA");
        kafkaAppender.setTopic("log");
        kafkaAppender.setHostname(this.getHostname());
        kafkaAppender.setZookeeper(this.getTwillRuntimeSpecification().getKafkaZKConnect());
        String runnableName = this.getRunnableName();
        if (runnableName != null) {
            kafkaAppender.setRunnableName(runnableName);
        }
        kafkaAppender.addFilter((Filter)new Filter<ILoggingEvent>(){

            public FilterReply decide(ILoggingEvent event) {
                return event.getLoggerName().startsWith("kafka.") ? FilterReply.DENY : FilterReply.ACCEPT;
            }
        });
        kafkaAppender.setContext((Context)context);
        return kafkaAppender;
    }

    static {
        if (!System.getenv().containsKey("HADOOP_HOME") && System.getProperty("hadoop.home.dir") == null) {
            System.setProperty("hadoop.home.dir", new File("").getAbsolutePath());
        }
    }

    protected static class TwillZKPathService
    extends AbstractIdleService {
        protected static final long TIMEOUT_SECONDS = 5L;
        private static final Logger LOG = LoggerFactory.getLogger(TwillZKPathService.class);
        private final ZKClient zkClient;
        private final String path;

        public TwillZKPathService(ZKClient zkClient, RunId runId) {
            this.zkClient = zkClient;
            this.path = "/" + runId.getId();
        }

        protected void startUp() throws Exception {
            LOG.info("Creating container ZK path: {}{}", (Object)this.zkClient.getConnectString(), (Object)this.path);
            ZKOperations.ignoreError((OperationFuture)this.zkClient.create(this.path, null, CreateMode.PERSISTENT), KeeperException.NodeExistsException.class, null).get(5L, TimeUnit.SECONDS);
        }

        protected void shutDown() throws Exception {
            LOG.info("Removing container ZK path: {}{}", (Object)this.zkClient.getConnectString(), (Object)this.path);
            ZKOperations.recursiveDelete((ZKClient)this.zkClient, (String)this.path).get(5L, TimeUnit.SECONDS);
        }
    }
}

