/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Service;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.twill.api.RunId;
import org.apache.twill.internal.ServiceMain;
import org.apache.twill.internal.TwillRuntimeSpecification;
import org.apache.twill.internal.appmaster.ApplicationMasterService;
import org.apache.twill.internal.appmaster.TrackerService;
import org.apache.twill.internal.json.TwillRuntimeSpecificationAdapter;
import org.apache.twill.internal.kafka.EmbeddedKafkaServer;
import org.apache.twill.internal.logging.Loggings;
import org.apache.twill.internal.yarn.VersionDetectYarnAMClientFactory;
import org.apache.twill.internal.yarn.YarnAMClient;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationMasterMain
extends ServiceMain {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationMasterMain.class);
    private final TwillRuntimeSpecification twillRuntimeSpec;

    public static void main(String[] args) throws Exception {
        File twillSpec = new File("runtime.config.jar", "twillSpec.json");
        TwillRuntimeSpecification twillRuntimeSpec = TwillRuntimeSpecificationAdapter.create().fromJson(twillSpec);
        new ApplicationMasterMain(twillRuntimeSpec).doMain();
    }

    private ApplicationMasterMain(TwillRuntimeSpecification twillRuntimeSpec) {
        this.twillRuntimeSpec = twillRuntimeSpec;
    }

    private void doMain() throws Exception {
        RunId runId = this.twillRuntimeSpec.getTwillAppRunId();
        ZKClientService zkClientService = this.createZKClient();
        YarnConfiguration conf = new YarnConfiguration((Configuration)new HdfsConfiguration(new Configuration()));
        ApplicationMasterMain.setRMSchedulerAddress((Configuration)conf, this.twillRuntimeSpec.getRmSchedulerAddr());
        YarnAMClient amClient = new VersionDetectYarnAMClientFactory((Configuration)conf).create();
        ApplicationMasterService service = new ApplicationMasterService(runId, (ZKClient)zkClientService, this.twillRuntimeSpec, amClient, (Configuration)conf, this.createAppLocation((Configuration)conf, this.twillRuntimeSpec.getFsUser(), this.twillRuntimeSpec.getTwillAppDir()));
        TrackerService trackerService = new TrackerService(service);
        ArrayList prerequisites = Lists.newArrayList((Object[])new Service[]{zkClientService, new AppMasterTwillZKPathService((ZKClient)zkClientService, runId), new YarnAMClientService(amClient, trackerService)});
        if (this.twillRuntimeSpec.isLogCollectionEnabled()) {
            prerequisites.add(new ApplicationKafkaService((ZKClient)zkClientService, this.twillRuntimeSpec.getKafkaZKConnect()));
        } else {
            LOG.info("Log collection through kafka disabled");
        }
        new ApplicationMasterMain(this.twillRuntimeSpec).doMain((Service)service, prerequisites.toArray(new Service[prerequisites.size()]));
    }

    private static void setRMSchedulerAddress(Configuration conf, String schedulerAddress) {
        if (schedulerAddress == null) {
            return;
        }
        String[] sources = conf.getPropertySources("yarn.resourcemanager.scheduler.address");
        if (sources == null || sources.length == 0 || "yarn-default.xml".equals(sources[sources.length - 1])) {
            conf.set("yarn.resourcemanager.scheduler.address", schedulerAddress);
        }
    }

    @Override
    protected String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    @Override
    protected TwillRuntimeSpecification getTwillRuntimeSpecification() {
        return this.twillRuntimeSpec;
    }

    @Override
    @Nullable
    protected String getRunnableName() {
        return null;
    }

    private static final class AppMasterTwillZKPathService
    extends ServiceMain.TwillZKPathService {
        private static final Logger LOG = LoggerFactory.getLogger(AppMasterTwillZKPathService.class);
        private final ZKClient zkClient;

        AppMasterTwillZKPathService(ZKClient zkClient, RunId runId) {
            super(zkClient, runId);
            this.zkClient = zkClient;
        }

        @Override
        protected void shutDown() throws Exception {
            super.shutDown();
            if (!this.delete("/instances")) {
                return;
            }
            List<String> children = this.getChildren("/discoverable");
            ArrayList<OperationFuture> deleteFutures = new ArrayList<OperationFuture>();
            for (String child : children) {
                String path = "/discoverable/" + child;
                LOG.info("Removing ZK path: {}{}", (Object)this.zkClient.getConnectString(), (Object)path);
                deleteFutures.add(this.zkClient.delete(path));
            }
            Futures.successfulAsList(deleteFutures).get(5L, TimeUnit.SECONDS);
            for (OperationFuture future : deleteFutures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof KeeperException.NotEmptyException) {
                        return;
                    }
                    if (e.getCause() instanceof KeeperException.NoNodeException) continue;
                    throw e;
                }
            }
            if (!this.delete("/discoverable")) {
                return;
            }
            this.delete("/");
        }

        private boolean delete(String path) throws Exception {
            try {
                LOG.info("Removing ZK path: {}{}", (Object)this.zkClient.getConnectString(), (Object)path);
                this.zkClient.delete(path).get(5L, TimeUnit.SECONDS);
                return true;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof KeeperException.NotEmptyException) {
                    return false;
                }
                if (e.getCause() instanceof KeeperException.NoNodeException) {
                    return true;
                }
                throw e;
            }
        }

        private List<String> getChildren(String path) throws Exception {
            try {
                return ((NodeChildren)this.zkClient.getChildren(path).get(5L, TimeUnit.SECONDS)).getChildren();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof KeeperException.NoNodeException) {
                    return Collections.emptyList();
                }
                throw e;
            }
        }
    }

    private static final class YarnAMClientService
    extends AbstractIdleService {
        private final YarnAMClient yarnAMClient;
        private final TrackerService trackerService;

        private YarnAMClientService(YarnAMClient yarnAMClient, TrackerService trackerService) {
            this.yarnAMClient = yarnAMClient;
            this.trackerService = trackerService;
        }

        protected void startUp() throws Exception {
            this.trackerService.setHost(this.yarnAMClient.getHost());
            this.trackerService.startAndWait();
            this.yarnAMClient.setTracker(this.trackerService.getBindAddress(), this.trackerService.getUrl());
            try {
                this.yarnAMClient.startAndWait();
            }
            catch (Exception e) {
                this.trackerService.stopAndWait();
                throw e;
            }
        }

        protected void shutDown() throws Exception {
            try {
                this.yarnAMClient.stopAndWait();
            }
            finally {
                this.trackerService.stopAndWait();
            }
        }
    }

    private static final class ApplicationKafkaService
    extends AbstractIdleService {
        private static final Logger LOG = LoggerFactory.getLogger(ApplicationKafkaService.class);
        private final ZKClient zkClient;
        private final EmbeddedKafkaServer kafkaServer;
        private final String kafkaZKPath;

        private ApplicationKafkaService(ZKClient zkClient, String kafkaZKConnect) {
            this.zkClient = zkClient;
            this.kafkaServer = new EmbeddedKafkaServer(this.generateKafkaConfig(kafkaZKConnect));
            this.kafkaZKPath = kafkaZKConnect.substring(zkClient.getConnectString().length());
        }

        protected void startUp() throws Exception {
            LOG.info("Preparing Kafka ZK path {}{}", (Object)this.zkClient.getConnectString(), (Object)this.kafkaZKPath);
            ZKOperations.createDeleteIfExists((ZKClient)this.zkClient, (String)this.kafkaZKPath, null, (CreateMode)CreateMode.PERSISTENT, (boolean)true, (ACL[])new ACL[0]).get();
            this.kafkaServer.startAndWait();
        }

        protected void shutDown() throws Exception {
            Loggings.forceFlush();
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                LOG.info("Kafka shutdown delay interrupted", (Throwable)e);
            }
            finally {
                this.kafkaServer.stopAndWait();
            }
        }

        private Properties generateKafkaConfig(String kafkaZKConnect) {
            Properties prop = new Properties();
            prop.setProperty("log.dir", new File("kafka-logs").getAbsolutePath());
            prop.setProperty("broker.id", "1");
            prop.setProperty("socket.send.buffer.bytes", "1048576");
            prop.setProperty("socket.receive.buffer.bytes", "1048576");
            prop.setProperty("socket.request.max.bytes", "104857600");
            prop.setProperty("num.partitions", "1");
            prop.setProperty("log.retention.hours", "24");
            prop.setProperty("log.flush.interval.messages", "10000");
            prop.setProperty("log.flush.interval.ms", "1000");
            prop.setProperty("log.segment.bytes", "536870912");
            prop.setProperty("zookeeper.connect", kafkaZKConnect);
            prop.setProperty("zookeeper.connection.timeout.ms", "3000");
            prop.setProperty("default.replication.factor", "1");
            return prop;
        }
    }
}

