/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.appmaster.ApplicationMasterInfo;
import org.apache.twill.internal.appmaster.ApplicationSubmitter;
import org.apache.twill.internal.yarn.AbstractYarnProcessLauncher;
import org.apache.twill.internal.yarn.YarnLaunchContext;

public final class ApplicationMasterProcessLauncher
extends AbstractYarnProcessLauncher<ApplicationMasterInfo> {
    private final ApplicationSubmitter submitter;

    public ApplicationMasterProcessLauncher(ApplicationMasterInfo info, ApplicationSubmitter submitter) {
        super(info);
        this.submitter = submitter;
    }

    @Override
    protected <R> ProcessController<R> doLaunch(YarnLaunchContext launchContext) {
        ApplicationMasterInfo appMasterInfo = (ApplicationMasterInfo)this.getContainerInfo();
        ApplicationId appId = appMasterInfo.getAppId();
        ImmutableMap env = ImmutableMap.builder().putAll(launchContext.getEnvironment()).put((Object)"YARN_APP_ID", (Object)Integer.toString(appId.getId())).put((Object)"YARN_APP_ID_CLUSTER_TIME", (Object)Long.toString(appId.getClusterTimestamp())).put((Object)"YARN_APP_ID_STR", (Object)appId.toString()).put((Object)"YARN_CONTAINER_MEMORY_MB", (Object)Integer.toString(appMasterInfo.getMemoryMB())).put((Object)"YARN_CONTAINER_VIRTUAL_CORES", (Object)Integer.toString(appMasterInfo.getVirtualCores())).build();
        launchContext.setEnvironment((Map<String, String>)env);
        return this.submitter.submit(launchContext);
    }
}

